/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.dnsservice.library.inetnetwork.model;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.james.dnsservice.library.inetnetwork.InetNetworkBuilder;
import org.apache.james.dnsservice.library.inetnetwork.model.InetNetwork;

public class Inet4Network
implements InetNetwork {
    private InetAddress network;
    private InetAddress netmask;

    public Inet4Network(InetAddress ip, InetAddress netmask) {
        this.network = Inet4Network.maskIP(ip, netmask);
        this.netmask = netmask;
    }

    @Override
    public boolean contains(InetAddress ip) {
        if (InetNetworkBuilder.isV6(ip.getHostAddress())) {
            return false;
        }
        try {
            return this.network.equals(Inet4Network.maskIP(ip, this.netmask));
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public String toString() {
        return this.network.getHostAddress() + "/" + this.netmask.getHostAddress();
    }

    public int hashCode() {
        return Inet4Network.maskIP(this.network, this.netmask).hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof InetNetwork && ((Inet4Network)obj).network.equals(this.network) && ((Inet4Network)obj).netmask.equals(this.netmask);
    }

    private static InetAddress maskIP(InetAddress ip, InetAddress mask) {
        return Inet4Network.maskIP(ip.getAddress(), mask.getAddress());
    }

    private static InetAddress maskIP(byte[] ip, byte[] mask) {
        if (ip.length != mask.length) {
            throw new IllegalArgumentException("IP address and mask must be of the same length.");
        }
        if (ip.length != 4) {
            throw new IllegalArgumentException("IP address and mask length must be equal to 4.");
        }
        try {
            byte[] maskedIp = new byte[ip.length];
            for (int i = 0; i < ip.length; ++i) {
                maskedIp[i] = (byte)(ip[i] & mask[i]);
            }
            return Inet4Network.getByAddress(maskedIp);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    private static InetAddress getByAddress(byte[] ip) throws UnknownHostException {
        InetAddress addr = null;
        addr = Inet4Address.getByAddress(ip);
        if (addr == null) {
            addr = InetAddress.getByName(Integer.toString(ip[0] & 0xFF, 10) + "." + Integer.toString(ip[1] & 0xFF, 10) + "." + Integer.toString(ip[2] & 0xFF, 10) + "." + Integer.toString(ip[3] & 0xFF, 10));
        }
        return addr;
    }
}

