/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.dnsservice.library.netmatcher;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.dnsservice.library.inetnetwork.InetNetworkBuilder;
import org.apache.james.dnsservice.library.inetnetwork.model.InetNetwork;

public class NetMatcher {
    private DNSService dnsServer;
    private SortedSet<InetNetwork> networks;

    public NetMatcher(String[] nets, DNSService dnsServer) {
        this.dnsServer = dnsServer;
        this.initInetNetworks(nets);
    }

    public NetMatcher(Collection<String> nets, DNSService dnsServer) {
        this.dnsServer = dnsServer;
        this.initInetNetworks(nets);
    }

    public boolean matchInetNetwork(String hostIP) {
        InetAddress ip = null;
        try {
            ip = this.dnsServer.getByName(hostIP);
        }
        catch (UnknownHostException uhe) {
            this.log("Cannot resolve address for " + hostIP + ": " + uhe.getMessage());
            return false;
        }
        return this.matchInetNetwork(ip);
    }

    public boolean matchInetNetwork(InetAddress ip) {
        boolean sameNet = false;
        Iterator iter = this.networks.iterator();
        while (!sameNet && iter.hasNext()) {
            InetNetwork network = (InetNetwork)iter.next();
            sameNet = network.contains(ip);
        }
        return sameNet;
    }

    public String toString() {
        return this.networks.toString();
    }

    protected void log(String s) {
    }

    private void initInetNetworks(Collection<String> nets) {
        this.initInetNetworks(nets.toArray(new String[0]));
    }

    private void initInetNetworks(String[] nets) {
        this.networks = new TreeSet<InetNetwork>(new Comparator<InetNetwork>(){

            @Override
            public int compare(InetNetwork in1, InetNetwork in2) {
                return in1.toString().compareTo(in2.toString());
            }
        });
        InetNetworkBuilder inetNetwork = new InetNetworkBuilder(this.dnsServer);
        for (String net : nets) {
            try {
                InetNetwork inet = inetNetwork.getFromString(net);
                this.networks.add(inet);
            }
            catch (UnknownHostException uhe) {
                this.log("Cannot resolve address: " + uhe.getMessage());
            }
        }
    }
}

