/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.adapter.mailbox;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.apache.james.adapter.mailbox.MailboxManagerManagementMBean;
import org.apache.james.lifecycle.api.LogEnabled;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxMetaData;
import org.apache.james.mailbox.MailboxPath;
import org.apache.james.mailbox.MailboxQuery;
import org.apache.james.mailbox.MailboxSession;
import org.slf4j.Logger;

public class MailboxManagerManagement
extends StandardMBean
implements MailboxManagerManagementMBean,
LogEnabled {
    private MailboxManager mailboxManager;
    private Logger log;

    @Resource(name="mailboxmanager")
    public void setMailboxManager(MailboxManager mailboxManager) {
        this.mailboxManager = mailboxManager;
    }

    public MailboxManagerManagement() throws NotCompliantMBeanException {
        super(MailboxManagerManagementMBean.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteMailboxes(String username) {
        MailboxSession session = null;
        try {
            session = this.mailboxManager.createSystemSession(username, this.log);
            this.mailboxManager.startProcessingRequest(session);
            List mList = this.mailboxManager.search(new MailboxQuery(MailboxPath.inbox((MailboxSession)session), "", session.getPathDelimiter()), session);
            for (int i = 0; i < mList.size(); ++i) {
                this.mailboxManager.deleteMailbox(((MailboxMetaData)mList.get(i)).getPath(), session);
            }
            boolean bl = true;
            return bl;
        }
        catch (MailboxException e) {
            this.log.error("Error while remove mailboxes for user " + username, (Throwable)e);
        }
        finally {
            if (session != null) {
                this.mailboxManager.endProcessingRequest(session);
                try {
                    this.mailboxManager.logout(session, true);
                }
                catch (MailboxException mailboxException) {}
            }
        }
        return false;
    }

    public void setLog(Logger log) {
        this.log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> listMailboxes(String username) {
        ArrayList<String> boxes = new ArrayList<String>();
        MailboxSession session = null;
        try {
            session = this.mailboxManager.createSystemSession(username, this.log);
            this.mailboxManager.startProcessingRequest(session);
            List mList = this.mailboxManager.search(new MailboxQuery(MailboxPath.inbox((MailboxSession)session), "", session.getPathDelimiter()), session);
            for (int i = 0; i < mList.size(); ++i) {
                boxes.add(((MailboxMetaData)mList.get(i)).getPath().getName());
            }
            Collections.sort(boxes);
        }
        catch (MailboxException e) {
            this.log.error("Error list mailboxes for user " + username, (Throwable)e);
        }
        finally {
            if (session != null) {
                this.mailboxManager.endProcessingRequest(session);
                try {
                    this.mailboxManager.logout(session, true);
                }
                catch (MailboxException e) {}
            }
        }
        return boxes;
    }
}

