/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.activemq;

import java.io.IOException;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import org.apache.activemq.command.ActiveMQBlobMessage;
import org.apache.james.queue.activemq.ActiveMQSupport;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.jms.JMSMailQueueItem;
import org.apache.mailet.Mail;
import org.slf4j.Logger;

public class ActiveMQMailQueueItem
extends JMSMailQueueItem
implements ActiveMQSupport {
    private final Message message;
    private final Logger logger;

    public ActiveMQMailQueueItem(Mail mail, Connection connection, Session session, MessageConsumer consumer, Message message, Logger logger) {
        super(mail, connection, session, consumer);
        this.message = message;
        this.logger = logger;
    }

    public void done(boolean success) throws MailQueue.MailQueueException {
        super.done(success);
        if (success) {
            if (this.message instanceof ActiveMQBlobMessage && this.getMail().getAttribute(" JAMES_REUSE_BLOB_URL") == null) {
                try {
                    ((ActiveMQBlobMessage)this.message).deleteFile();
                }
                catch (IOException e) {
                    this.logger.info("Unable to delete blob message file for mail " + this.getMail().getName());
                }
                catch (JMSException e) {
                    this.logger.info("Unable to delete blob message file for mail " + this.getMail().getName());
                }
            }
            this.getMail().removeAttribute(" JAMES_REUSE_BLOB_URL");
        }
    }
}

