/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.activemq;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.jms.JMSException;
import org.apache.activemq.blob.BlobDownloadStrategy;
import org.apache.activemq.blob.BlobTransferPolicy;
import org.apache.activemq.blob.BlobUploadStrategy;
import org.apache.activemq.command.ActiveMQBlobMessage;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.queue.activemq.ActiveMQSupport;

public class FileSystemBlobStrategy
implements BlobUploadStrategy,
BlobDownloadStrategy,
ActiveMQSupport {
    private final FileSystem fs;
    private final BlobTransferPolicy policy;
    private int splitCount;

    public FileSystemBlobStrategy(BlobTransferPolicy policy, FileSystem fs, int splitCount) {
        this.fs = fs;
        this.policy = policy;
        this.splitCount = splitCount;
    }

    public URL uploadFile(ActiveMQBlobMessage message, File file) throws JMSException, IOException {
        return this.uploadStream(message, new FileInputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL uploadStream(ActiveMQBlobMessage message, InputStream in) throws JMSException, IOException {
        FileOutputStream out = null;
        try {
            File f = this.getFile(message);
            out = new FileOutputStream(f);
            byte[] buffer = new byte[this.policy.getBufferSize()];
            int c = in.read(buffer);
            while (c != -1) {
                out.write(buffer, 0, c);
                out.flush();
                c = in.read(buffer);
            }
            out.flush();
            URL uRL = f.toURI().toURL();
            return uRL;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void deleteFile(ActiveMQBlobMessage message) throws IOException, JMSException {
        File f = this.getFile(message);
        if (f.exists() && !f.delete()) {
            throw new IOException("Unable to delete file " + f);
        }
    }

    public InputStream getInputStream(ActiveMQBlobMessage message) throws IOException, JMSException {
        File f = this.getFile(message);
        return new FileInputStream(f);
    }

    protected File getFile(ActiveMQBlobMessage message) throws JMSException, IOException {
        if (message.getURL() != null) {
            return this.fs.getFile(message.getURL().toString());
        }
        String filename = message.getJMSMessageID().replaceAll("[:\\\\/*?|<>]", "_");
        int i = (int)(Math.random() * (double)this.splitCount + 1.0);
        String queueUrl = this.policy.getUploadUrl() + "/" + i;
        File queueF = this.fs.getFile(queueUrl);
        if (!queueF.exists() && !queueF.mkdirs()) {
            throw new IOException("Unable to create directory " + queueF.getAbsolutePath());
        }
        return this.fs.getFile(queueUrl + "/" + filename);
    }
}

