/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.activemq;

import javax.annotation.Resource;
import org.apache.activemq.blob.BlobDownloadStrategy;
import org.apache.activemq.blob.BlobTransferPolicy;
import org.apache.activemq.blob.BlobUploadStrategy;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.queue.activemq.FileSystemBlobStrategy;

public class FileSystemBlobTransferPolicy
extends BlobTransferPolicy {
    private FileSystem fs;
    private int splitCount = 10;
    private FileSystemBlobStrategy strategy;

    @Resource(name="filesystem")
    public void setFileSystem(FileSystem fs) {
        this.fs = fs;
    }

    public void setSplitCount(int splitCount) {
        this.splitCount = splitCount;
    }

    public BlobTransferPolicy copy() {
        FileSystemBlobTransferPolicy that = new FileSystemBlobTransferPolicy();
        that.setFileSystem(this.fs);
        that.setDefaultUploadUrl(this.getDefaultUploadUrl());
        that.setBrokerUploadUrl(this.getBrokerUploadUrl());
        that.setUploadUrl(this.getUploadUrl());
        that.setUploadStrategy(this.getUploadStrategy());
        return that;
    }

    protected BlobDownloadStrategy createDownloadStrategy() {
        return this.getStrategy();
    }

    protected BlobUploadStrategy createUploadStrategy() {
        return this.getStrategy();
    }

    private synchronized FileSystemBlobStrategy getStrategy() {
        if (this.strategy == null) {
            this.strategy = new FileSystemBlobStrategy(this, this.fs, this.splitCount);
        }
        return this.strategy;
    }
}

