/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imapserver.netty;

import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.net.ssl.SSLEngine;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.decode.ImapDecoder;
import org.apache.james.imap.encode.ImapEncoder;
import org.apache.james.imapserver.netty.IMAPServerMBean;
import org.apache.james.imapserver.netty.ImapChannelUpstreamHandler;
import org.apache.james.imapserver.netty.ImapIdleStateHandler;
import org.apache.james.imapserver.netty.ImapRequestFrameDecoder;
import org.apache.james.imapserver.netty.NettyConstants;
import org.apache.james.protocols.impl.ChannelGroupHandler;
import org.apache.james.protocols.lib.netty.AbstractConfigurableAsyncServer;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.handler.codec.frame.DelimiterBasedFrameDecoder;
import org.jboss.netty.handler.codec.frame.Delimiters;
import org.jboss.netty.handler.codec.oneone.OneToOneEncoder;
import org.jboss.netty.handler.connection.ConnectionLimitUpstreamHandler;
import org.jboss.netty.handler.connection.ConnectionPerIpLimitUpstreamHandler;
import org.jboss.netty.handler.execution.ExecutionHandler;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.handler.stream.ChunkedWriteHandler;
import org.jboss.netty.handler.timeout.IdleStateHandler;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;

public class IMAPServer
extends AbstractConfigurableAsyncServer
implements ImapConstants,
IMAPServerMBean,
NettyConstants {
    private static final String softwaretype = "JAMES IMAP4rev1 Server ";
    private String hello;
    private ImapProcessor processor;
    private ImapEncoder encoder;
    private ImapDecoder decoder;
    private boolean compress;
    private int maxLineLength;
    private int inMemorySizeLimit;
    private boolean plainAuthDisallowed;
    public static final int DEFAULT_MAX_LINE_LENGTH = 65536;
    public static final int DEFAULT_IN_MEMORY_SIZE_LIMIT = 0xA00000;

    @Resource(name="imapDecoder")
    public void setImapDecoder(ImapDecoder decoder) {
        this.decoder = decoder;
    }

    @Resource(name="imapEncoder")
    public void setImapEncoder(ImapEncoder encoder) {
        this.encoder = encoder;
    }

    @Resource(name="imapProcessor")
    public void setImapProcessor(ImapProcessor processor) {
        this.processor = processor;
    }

    public void doConfigure(HierarchicalConfiguration configuration) throws ConfigurationException {
        super.doConfigure(configuration);
        this.hello = "JAMES IMAP4rev1 Server  Server " + this.getHelloName() + " is ready.";
        this.compress = configuration.getBoolean("compress", false);
        this.maxLineLength = configuration.getInt("maxLineLength", 65536);
        this.inMemorySizeLimit = configuration.getInt("inMemorySizeLimit", 0xA00000);
        this.plainAuthDisallowed = configuration.getBoolean("plainAuthDisallowed", false);
    }

    public int getDefaultPort() {
        return 143;
    }

    public String getServiceType() {
        return "IMAP Service";
    }

    protected ChannelPipelineFactory createPipelineFactory(final ChannelGroup group) {
        return new ChannelPipelineFactory(){
            private final ChannelGroupHandler groupHandler;
            private final HashedWheelTimer timer;
            private static final int TIMEOUT = 1800;
            private final TimeUnit TIMEOUT_UNIT;
            {
                this.groupHandler = new ChannelGroupHandler(group);
                this.timer = new HashedWheelTimer();
                this.TIMEOUT_UNIT = TimeUnit.SECONDS;
            }

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = Channels.pipeline();
                pipeline.addLast("groupHandler", (ChannelHandler)this.groupHandler);
                pipeline.addLast("idleHandler", (ChannelHandler)new IdleStateHandler((Timer)this.timer, 0L, 30L, 1800L, this.TIMEOUT_UNIT));
                pipeline.addLast("timeoutHandler", (ChannelHandler)new ImapIdleStateHandler());
                pipeline.addLast("connectionLimitHandler", (ChannelHandler)new ConnectionLimitUpstreamHandler(IMAPServer.this.connectionLimit));
                pipeline.addLast("connectionPerIpLimitHandler", (ChannelHandler)new ConnectionPerIpLimitUpstreamHandler(IMAPServer.this.connPerIP));
                pipeline.addLast("framer", (ChannelHandler)new DelimiterBasedFrameDecoder(IMAPServer.this.maxLineLength, false, Delimiters.lineDelimiter()));
                pipeline.addLast("requestDecoder", (ChannelHandler)new ImapRequestFrameDecoder(IMAPServer.this.decoder, IMAPServer.this.inMemorySizeLimit));
                if (IMAPServer.this.isSSLSocket()) {
                    SSLEngine engine = IMAPServer.this.getSSLContext().createSSLEngine();
                    engine.setUseClientMode(false);
                    pipeline.addFirst("sslHandler", (ChannelHandler)new SslHandler(engine));
                }
                pipeline.addLast("connectionCountHandler", (ChannelHandler)IMAPServer.this.getConnectionCountHandler());
                pipeline.addLast("chunkWriteHandler", (ChannelHandler)new ChunkedWriteHandler());
                ExecutionHandler ehandler = IMAPServer.this.getExecutionHandler();
                if (ehandler != null) {
                    pipeline.addLast("executionHandler", (ChannelHandler)ehandler);
                }
                pipeline.addLast("coreHandler", (ChannelHandler)IMAPServer.this.createCoreHandler());
                return pipeline;
            }
        };
    }

    protected String getDefaultJMXName() {
        return "imapserver";
    }

    protected ChannelUpstreamHandler createCoreHandler() {
        ImapChannelUpstreamHandler coreHandler = this.isStartTLSSupported() ? new ImapChannelUpstreamHandler(this.hello, this.processor, this.encoder, this.getLogger(), this.compress, this.plainAuthDisallowed, this.getSSLContext(), this.getEnabledCipherSuites()) : new ImapChannelUpstreamHandler(this.hello, this.processor, this.encoder, this.getLogger(), this.compress, this.plainAuthDisallowed);
        return coreHandler;
    }

    protected OneToOneEncoder createEncoder() {
        return null;
    }
}

