/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imapserver.netty;

import org.apache.james.imap.api.process.ImapLineHandler;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.protocols.impl.ChannelAttributeSupport;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;

public class ImapLineHandlerAdapter
extends SimpleChannelUpstreamHandler
implements ChannelAttributeSupport {
    private ImapLineHandler lineHandler;

    public ImapLineHandlerAdapter(ImapLineHandler lineHandler) {
        this.lineHandler = lineHandler;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        byte[] data;
        ChannelBuffer buf = (ChannelBuffer)e.getMessage();
        if (buf.hasArray()) {
            data = buf.array();
        } else {
            data = new byte[buf.readableBytes()];
            buf.readBytes(data);
        }
        this.lineHandler.onLine((ImapSession)attributes.get(ctx.getChannel()), data);
    }
}

