/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imapserver.netty;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.decode.ImapDecoder;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imapserver.netty.NettyImapRequestLineReader;
import org.apache.james.imapserver.netty.NettyStreamImapRequestLineReader;
import org.apache.james.protocols.impl.ChannelAttributeSupport;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferInputStream;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.handler.codec.frame.FrameDecoder;

public class ImapRequestFrameDecoder
extends FrameDecoder
implements ChannelAttributeSupport {
    private final ImapDecoder decoder;
    private final int inMemorySizeLimit;
    private static final String NEEDED_DATA = "NEEDED_DATA";
    private static final String STORED_DATA = "STORED_DATA";
    private static final String WRITTEN_DATA = "WRITTEN_DATA";

    public ImapRequestFrameDecoder(ImapDecoder decoder, int inMemorySizeLimit) {
        this.decoder = decoder;
        this.inMemorySizeLimit = inMemorySizeLimit;
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        ctx.setAttachment(new HashMap());
        super.channelOpen(ctx, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        int size;
        Map attachment;
        block13: {
            boolean retry;
            block11: {
                block12: {
                    buffer.markReaderIndex();
                    retry = false;
                    attachment = (Map)ctx.getAttachment();
                    size = -1;
                    if (!attachment.containsKey(NEEDED_DATA)) break block11;
                    retry = true;
                    size = (Integer)attachment.get(NEEDED_DATA);
                    if (size == -1 || size <= buffer.readableBytes()) break block12;
                    if (this.inMemorySizeLimit > 0 && this.inMemorySizeLimit < size) {
                        int written;
                        File f;
                        if (attachment.containsKey(STORED_DATA)) {
                            f = (File)attachment.get(STORED_DATA);
                            written = (Integer)attachment.get(WRITTEN_DATA);
                        } else {
                            f = File.createTempFile("imap-literal", ".tmp");
                            attachment.put(STORED_DATA, f);
                            written = 0;
                            attachment.put(WRITTEN_DATA, written);
                        }
                        ChannelBufferInputStream bufferIn = null;
                        FileOutputStream out = null;
                        try {
                            bufferIn = new ChannelBufferInputStream(buffer);
                            out = new FileOutputStream(f, true);
                            int i = -1;
                            while (written < size && (i = bufferIn.read()) != -1) {
                                ((OutputStream)out).write(i);
                                ++written;
                            }
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(bufferIn);
                            IOUtils.closeQuietly(out);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((InputStream)bufferIn);
                        IOUtils.closeQuietly((OutputStream)out);
                        if (written != size) {
                            attachment.put(WRITTEN_DATA, written);
                            return null;
                        }
                        NettyStreamImapRequestLineReader nettyStreamImapRequestLineReader = new NettyStreamImapRequestLineReader(channel, new FileInputStream(f){

                            @Override
                            public void close() throws IOException {
                                super.close();
                                f.delete();
                            }
                        }, retry);
                        break block13;
                    } else {
                        buffer.resetReaderIndex();
                        return null;
                    }
                }
                NettyImapRequestLineReader nettyImapRequestLineReader = new NettyImapRequestLineReader(channel, buffer, retry);
                break block13;
            }
            NettyImapRequestLineReader nettyImapRequestLineReader = new NettyImapRequestLineReader(channel, buffer, retry);
        }
        try {
            void var5_17;
            ImapMessage message = this.decoder.decode((ImapRequestLineReader)var5_17, (ImapSession)attributes.get(channel));
            if (size == -1) {
                var5_17.consumeLine();
            }
            attachment.clear();
            return message;
        }
        catch (NettyImapRequestLineReader.NotEnoughDataException e) {
            int neededData = e.getNeededSize();
            attachment.put(NEEDED_DATA, neededData);
            buffer.resetReaderIndex();
            return null;
        }
    }
}

