/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imapserver.netty;

import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.james.imap.api.ImapSessionState;
import org.apache.james.imap.api.process.ImapLineHandler;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.imapserver.netty.ImapLineHandlerAdapter;
import org.apache.james.imapserver.netty.NettyConstants;
import org.apache.james.protocols.impl.SessionLog;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.compression.ZlibDecoder;
import org.jboss.netty.handler.codec.compression.ZlibEncoder;
import org.jboss.netty.handler.codec.compression.ZlibWrapper;
import org.jboss.netty.handler.ssl.SslHandler;
import org.slf4j.Logger;

public class NettyImapSession
implements ImapSession,
NettyConstants {
    private ImapSessionState state = ImapSessionState.NON_AUTHENTICATED;
    private SelectedMailbox selectedMailbox;
    private Map<String, Object> attributesByKey = new HashMap<String, Object>();
    private SSLContext sslContext;
    private String[] enabledCipherSuites;
    private boolean compress;
    private SessionLog log;
    private ChannelHandlerContext context;
    private int handlerCount;
    private boolean plainAuthDisallowed;

    public NettyImapSession(ChannelHandlerContext context, Logger log, SSLContext sslContext, String[] enabledCipherSuites, boolean compress, boolean plainAuthDisallowed) {
        this.context = context;
        this.log = new SessionLog(context.getChannel().getId() + "", log);
        this.sslContext = sslContext;
        this.enabledCipherSuites = enabledCipherSuites;
        this.compress = compress;
        this.plainAuthDisallowed = plainAuthDisallowed;
    }

    public Channel getChannel() {
        return this.context.getChannel();
    }

    public void logout() {
        this.closeMailbox();
        this.state = ImapSessionState.LOGOUT;
    }

    public void authenticated() {
        this.state = ImapSessionState.AUTHENTICATED;
    }

    public void deselect() {
        this.state = ImapSessionState.AUTHENTICATED;
        this.closeMailbox();
    }

    public void selected(SelectedMailbox mailbox) {
        this.state = ImapSessionState.SELECTED;
        this.closeMailbox();
        this.selectedMailbox = mailbox;
    }

    public SelectedMailbox getSelected() {
        return this.selectedMailbox;
    }

    public ImapSessionState getState() {
        return this.state;
    }

    private void closeMailbox() {
        if (this.selectedMailbox != null) {
            this.selectedMailbox.deselect();
            this.selectedMailbox = null;
        }
    }

    public Object getAttribute(String key) {
        Object result = this.attributesByKey.get(key);
        return result;
    }

    public void setAttribute(String key, Object value) {
        if (value == null) {
            this.attributesByKey.remove(key);
        } else {
            this.attributesByKey.put(key, value);
        }
    }

    public boolean startTLS() {
        if (!this.supportStartTLS()) {
            return false;
        }
        this.context.getChannel().setReadable(false);
        SslHandler filter = new SslHandler(this.sslContext.createSSLEngine(), false);
        filter.getEngine().setUseClientMode(false);
        if (this.enabledCipherSuites != null && this.enabledCipherSuites.length > 0) {
            filter.getEngine().setEnabledCipherSuites(this.enabledCipherSuites);
        }
        this.context.getPipeline().addFirst("sslHandler", (ChannelHandler)filter);
        this.context.getChannel().setReadable(true);
        return true;
    }

    public boolean supportStartTLS() {
        return this.sslContext != null;
    }

    public boolean isCompressionSupported() {
        return this.compress;
    }

    public boolean startCompression() {
        if (!this.isCompressionSupported()) {
            return false;
        }
        this.context.getChannel().setReadable(false);
        ZlibDecoder decoder = new ZlibDecoder(ZlibWrapper.NONE);
        ZlibEncoder encoder = new ZlibEncoder(ZlibWrapper.NONE, 5);
        if (this.context.getPipeline().get("sslHandler") == null) {
            this.context.getPipeline().addFirst("zlibDecoder", (ChannelHandler)decoder);
            this.context.getPipeline().addFirst("zlibEncoder", (ChannelHandler)encoder);
        } else {
            this.context.getPipeline().addAfter("sslHandler", "zlibDecoder", (ChannelHandler)decoder);
            this.context.getPipeline().addAfter("sslHandler", "zlibEncoder", (ChannelHandler)encoder);
        }
        this.context.getChannel().setReadable(true);
        return true;
    }

    public void pushLineHandler(ImapLineHandler lineHandler) {
        this.context.getPipeline().addBefore("requestDecoder", "lineHandler" + this.handlerCount++, (ChannelHandler)new ImapLineHandlerAdapter(lineHandler));
    }

    public void popLineHandler() {
        this.context.getPipeline().remove("lineHandler" + --this.handlerCount);
    }

    public Logger getLog() {
        return this.log;
    }

    public boolean isPlainAuthDisallowed() {
        return this.plainAuthDisallowed;
    }

    public boolean isTLSActive() {
        return this.context.getPipeline().get("sslHandler") != null;
    }

    public boolean supportMultipleNamespaces() {
        return false;
    }

    public boolean isCompressionActive() {
        return this.context.getPipeline().get("zlibDecoder") != null;
    }
}

