/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.api.display;

import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class CharsetUtil {
    private static Set<String> charsetNames;
    private static Set<Charset> charsets;

    public static final Set<String> getAvailableCharsetNames() {
        return charsetNames;
    }

    public static final Set<Charset> getAvailableCharsets() {
        return charsets;
    }

    static {
        HashSet<String> cNames = new HashSet<String>();
        HashSet<Charset> sets = new HashSet<Charset>();
        for (Charset charset : Charset.availableCharsets().values()) {
            Set<String> aliases = charset.aliases();
            cNames.add(charset.name());
            cNames.addAll(aliases);
            sets.add(charset);
        }
        charsetNames = Collections.unmodifiableSet(cNames);
        charsets = Collections.unmodifiableSet(sets);
    }
}

