/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.api.message;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class IdRange {
    private long _lowVal;
    private long _highVal;

    public IdRange(long singleVal) {
        this._lowVal = singleVal;
        this._highVal = singleVal;
    }

    public IdRange(long lowVal, long highVal) {
        if (lowVal > highVal) {
            throw new IllegalArgumentException("LowVal must be <= HighVal");
        }
        this._lowVal = lowVal;
        this._highVal = highVal;
    }

    public long getLowVal() {
        return this._lowVal;
    }

    public long getHighVal() {
        return this._highVal;
    }

    public void setLowVal(long lowVal) {
        if (lowVal > this._highVal) {
            throw new IllegalArgumentException("LowVal must be <= HighVal");
        }
        this._lowVal = lowVal;
    }

    public void setHighVal(long highVal) {
        if (this._lowVal > highVal) {
            throw new IllegalArgumentException("HighVal must be >= LowVal");
        }
        this._highVal = highVal;
    }

    public boolean includes(long value) {
        return this._lowVal <= value && value <= this._highVal;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (int)(this._highVal ^ this._highVal >>> 32);
        result = 31 * result + (int)(this._lowVal ^ this._lowVal >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IdRange other = (IdRange)obj;
        if (this._highVal != other._highVal) {
            return false;
        }
        return this._lowVal == other._lowVal;
    }

    public String toString() {
        String retValue = "IdRange ( " + this._lowVal + "->" + this._highVal + " )";
        return retValue;
    }

    public String getFormattedString() {
        if (this._lowVal == this._highVal) {
            return Long.toString(this._lowVal);
        }
        return this._lowVal + ":" + this._highVal;
    }

    public static List<IdRange> mergeRanges(List<IdRange> ranges) {
        ArrayList<IdRange> copy = new ArrayList<IdRange>(ranges);
        Collections.sort(copy, IdRangeComperator.INSTANCE);
        boolean lastUid = false;
        for (int i = 0; i < copy.size() - 1; ++i) {
            IdRange current = (IdRange)copy.get(i);
            IdRange next = (IdRange)copy.get(i + 1);
            if (next.getLowVal() == Long.MAX_VALUE && next.getHighVal() == Long.MAX_VALUE) {
                if (lastUid) {
                    copy.remove(next);
                    --i;
                    continue;
                }
                lastUid = true;
                continue;
            }
            if (current.getLowVal() == Long.MAX_VALUE || current.getHighVal() == Long.MAX_VALUE || current.getHighVal() < next.getLowVal() - 1L) continue;
            if (next.getHighVal() > current.getHighVal()) {
                current.setHighVal(next.getHighVal());
            }
            copy.remove(next);
            --i;
        }
        return copy;
    }

    private static class IdRangeComperator
    implements Comparator<IdRange> {
        private static IdRangeComperator INSTANCE = new IdRangeComperator();

        private IdRangeComperator() {
        }

        @Override
        public int compare(IdRange range1, IdRange range2) {
            if (range1.getLowVal() == Long.MAX_VALUE && range1.getHighVal() == Long.MAX_VALUE && range2.getLowVal() == Long.MAX_VALUE && range2.getHighVal() == Long.MAX_VALUE) {
                return 0;
            }
            if (range1.getLowVal() == Long.MAX_VALUE && range1.getHighVal() == Long.MAX_VALUE) {
                return 1;
            }
            if (range2.getLowVal() == Long.MAX_VALUE && range2.getHighVal() == Long.MAX_VALUE) {
                return -1;
            }
            return (int)(range1.getLowVal() - range2.getLowVal());
        }
    }
}

