/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.mail.model.openjpa;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import javax.mail.Flags;
import javax.mail.internet.SharedInputStream;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Lob;
import javax.persistence.Table;
import org.apache.commons.io.IOUtils;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.jpa.mail.model.JPAMailbox;
import org.apache.james.mailbox.jpa.mail.model.openjpa.AbstractJPAMessage;
import org.apache.james.mailbox.store.mail.model.Message;
import org.apache.james.mailbox.store.mail.model.impl.PropertyBuilder;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;

@Entity(name="Message")
@Table(name="JAMES_MAIL")
public class JPAMessage
extends AbstractJPAMessage
implements PersistenceCapable {
    @Basic(optional=false, fetch=FetchType.LAZY)
    @Column(name="MAIL_BYTES", length=1048576000, nullable=false)
    @Lob
    private byte[] body;
    @Basic(optional=false, fetch=FetchType.LAZY)
    @Column(name="HEADER_BYTES", length=0xA00000, nullable=false)
    @Lob
    private byte[] header;
    private static int pcInheritedFieldCount = AbstractJPAMessage.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    static /* synthetic */ Class class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$AbstractJPAMessage;
    static /* synthetic */ Class class$L$B;
    static /* synthetic */ Class class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$JPAMessage;

    @Deprecated
    public JPAMessage() {
    }

    public JPAMessage(JPAMailbox mailbox, Date internalDate, int size, Flags flags, SharedInputStream content, int bodyStartOctet, PropertyBuilder propertyBuilder) throws MailboxException {
        super(mailbox, internalDate, flags, size, bodyStartOctet, propertyBuilder);
        try {
            int headerEnd = bodyStartOctet - 2;
            if (headerEnd < 0) {
                headerEnd = 0;
            }
            this.header = IOUtils.toByteArray((InputStream)content.newStream(0L, (long)headerEnd));
            this.body = IOUtils.toByteArray((InputStream)content.newStream((long)this.getBodyStartOctet(), -1L));
        }
        catch (IOException e) {
            throw new MailboxException("Unable to parse message", (Exception)e);
        }
    }

    public JPAMessage(JPAMailbox mailbox, long uid, long modSeq, Message<?> message) throws MailboxException {
        super(mailbox, uid, modSeq, message);
        try {
            this.body = IOUtils.toByteArray((InputStream)message.getBodyContent());
            this.header = IOUtils.toByteArray((InputStream)message.getHeaderContent());
        }
        catch (IOException e) {
            throw new MailboxException("Unable to parse message", (Exception)e);
        }
    }

    public InputStream getBodyContent() throws IOException {
        return new ByteArrayInputStream(JPAMessage.pcGetbody(this));
    }

    public InputStream getHeaderContent() throws IOException {
        return new ByteArrayInputStream(JPAMessage.pcGetheader(this));
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 2;
    }

    static {
        Class clazz = class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$AbstractJPAMessage != null ? class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$AbstractJPAMessage : (class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$AbstractJPAMessage = JPAMessage.class$("org.apache.james.mailbox.jpa.mail.model.openjpa.AbstractJPAMessage"));
        pcPCSuperclass = clazz;
        pcFieldNames = new String[]{"body", "header"};
        Class[] classArray = new Class[2];
        Class clazz2 = class$L$B != null ? class$L$B : (class$L$B = JPAMessage.class$("[B"));
        classArray[0] = clazz2;
        classArray[1] = class$L$B != null ? class$L$B : (class$L$B = JPAMessage.class$("[B"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{21, 21};
        Class clazz3 = class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$JPAMessage != null ? class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$JPAMessage : (class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$JPAMessage = JPAMessage.class$("org.apache.james.mailbox.jpa.mail.model.openjpa.JPAMessage"));
        PCRegistry.register((Class)clazz3, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"Message", (PersistenceCapable)new JPAMessage());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.body = null;
        this.header = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JPAMessage jPAMessage = new JPAMessage();
        if (bl) {
            jPAMessage.pcClearFields();
        }
        jPAMessage.pcStateManager = stateManager;
        jPAMessage.pcCopyKeyFieldsFromObjectId(object);
        return jPAMessage;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JPAMessage jPAMessage = new JPAMessage();
        if (bl) {
            jPAMessage.pcClearFields();
        }
        jPAMessage.pcStateManager = stateManager;
        return jPAMessage;
    }

    protected static int pcGetManagedFieldCount() {
        return 2 + AbstractJPAMessage.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.body = (byte[])this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.header = (byte[])this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.body);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.header);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(JPAMessage jPAMessage, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(jPAMessage, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.body = jPAMessage.body;
                return;
            }
            case 1: {
                this.header = jPAMessage.header;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        JPAMessage jPAMessage = (JPAMessage)((Object)object);
        if (jPAMessage.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(jPAMessage, nArray[n]);
            ++n;
        }
    }

    @Override
    public Class pcGetIDOwningClass() {
        Class clazz = class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$JPAMessage != null ? class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$JPAMessage : (class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$JPAMessage = JPAMessage.class$("org.apache.james.mailbox.jpa.mail.model.openjpa.JPAMessage"));
        return clazz;
    }

    private static final byte[] pcGetbody(JPAMessage jPAMessage) {
        if (jPAMessage.pcStateManager == null) {
            return jPAMessage.body;
        }
        int n = pcInheritedFieldCount + 0;
        jPAMessage.pcStateManager.accessingField(n);
        return jPAMessage.body;
    }

    private static final void pcSetbody(JPAMessage jPAMessage, byte[] byArray) {
        if (jPAMessage.pcStateManager == null) {
            jPAMessage.body = byArray;
            return;
        }
        jPAMessage.pcStateManager.settingObjectField((PersistenceCapable)jPAMessage, pcInheritedFieldCount + 0, (Object)jPAMessage.body, (Object)byArray, 0);
    }

    private static final byte[] pcGetheader(JPAMessage jPAMessage) {
        if (jPAMessage.pcStateManager == null) {
            return jPAMessage.header;
        }
        int n = pcInheritedFieldCount + 1;
        jPAMessage.pcStateManager.accessingField(n);
        return jPAMessage.header;
    }

    private static final void pcSetheader(JPAMessage jPAMessage, byte[] byArray) {
        if (jPAMessage.pcStateManager == null) {
            jPAMessage.header = byArray;
            return;
        }
        jPAMessage.pcStateManager.settingObjectField((PersistenceCapable)jPAMessage, pcInheritedFieldCount + 1, (Object)jPAMessage.header, (Object)byArray, 0);
    }
}

