/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.api;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.james.protocols.api.BaseRequest;
import org.apache.james.protocols.api.CommandHandler;
import org.apache.james.protocols.api.CommandHandlerResultHandler;
import org.apache.james.protocols.api.ExtensibleHandler;
import org.apache.james.protocols.api.LineHandler;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.WiringException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCommandDispatcher<Session extends ProtocolSession>
implements ExtensibleHandler,
LineHandler<Session> {
    private HashMap<String, List<CommandHandler<Session>>> commandHandlerMap = new HashMap();
    private List<CommandHandlerResultHandler<Response, Session>> rHandlers = new ArrayList<CommandHandlerResultHandler<Response, Session>>();

    protected void addToMap(String commandName, CommandHandler<Session> cmdHandler) {
        List<CommandHandler<Session>> handlers = this.commandHandlerMap.get(commandName);
        if (handlers == null) {
            handlers = new ArrayList<CommandHandler<Session>>();
            this.commandHandlerMap.put(commandName, handlers);
        }
        handlers.add(cmdHandler);
    }

    protected List<CommandHandler<Session>> getCommandHandlers(String command, ProtocolSession session) {
        List<CommandHandler<Session>> handlers;
        if (command == null) {
            return null;
        }
        if (session.getLogger().isDebugEnabled()) {
            session.getLogger().debug("Lookup command handler for command: " + command);
        }
        if ((handlers = this.commandHandlerMap.get(command)) == null) {
            handlers = this.commandHandlerMap.get(this.getUnknownCommandHandlerIdentifier());
        }
        return handlers;
    }

    public void wireExtensions(Class interfaceName, List extension) throws WiringException {
        if (interfaceName.equals(CommandHandlerResultHandler.class)) {
            this.rHandlers.addAll(extension);
        }
        if (interfaceName.equals(CommandHandler.class)) {
            for (CommandHandler handler : extension) {
                Collection<String> implCmds = handler.getImplCommands();
                Iterator<String> i = implCmds.iterator();
                while (i.hasNext()) {
                    String commandName = i.next().trim().toUpperCase(Locale.US);
                    this.addToMap(commandName, handler);
                }
            }
            this.addToMap(this.getUnknownCommandHandlerIdentifier(), this.getUnknownCommandHandler());
            if (this.commandHandlerMap.size() < 2) {
                throw new WiringException("No commandhandlers configured");
            }
            List<String> mandatoryCommands = this.getMandatoryCommands();
            for (int i = 0; i < mandatoryCommands.size(); ++i) {
                String cmd = mandatoryCommands.get(i);
                if (this.commandHandlerMap.containsKey(mandatoryCommands.get(i))) continue;
                throw new WiringException("No commandhandlers configured for mandatory command " + cmd);
            }
        }
    }

    @Override
    public boolean onLine(Session session, byte[] line) {
        String curCommandName = null;
        String curCommandArgument = null;
        try {
            String cmdString = new String(line, this.getLineDecodingCharset()).trim();
            int spaceIndex = cmdString.indexOf(" ");
            if (spaceIndex > 0) {
                curCommandName = cmdString.substring(0, spaceIndex);
                curCommandArgument = cmdString.substring(spaceIndex + 1);
            } else {
                curCommandName = cmdString;
            }
            curCommandName = curCommandName.toUpperCase(Locale.US);
            if (session.getLogger().isDebugEnabled()) {
                session.getLogger().debug(this.getClass().getName() + " received: " + cmdString);
            }
            List<CommandHandler<Session>> commandHandlers = this.getCommandHandlers(curCommandName, (ProtocolSession)session);
            int count = commandHandlers.size();
            for (int i = 0; i < count; ++i) {
                CommandHandler<Session> cHandler = commandHandlers.get(i);
                long start = System.currentTimeMillis();
                Response response = cHandler.onCommand(session, new BaseRequest(curCommandName, curCommandArgument));
                long executionTime = System.currentTimeMillis() - start;
                if (response == null) continue;
                for (int a = 0; a < this.rHandlers.size(); ++a) {
                    response = this.rHandlers.get(a).onResponse((ProtocolSession)session, response, executionTime, cHandler);
                }
                session.writeResponse(response);
                break;
            }
        }
        catch (UnsupportedEncodingException e) {
            session.getLogger().error("Unable to handle encoding", (Throwable)e);
        }
        return false;
    }

    protected String getLineDecodingCharset() {
        return "US-ASCII";
    }

    @Override
    public List<Class<?>> getMarkerInterfaces() {
        LinkedList res = new LinkedList();
        res.add(CommandHandler.class);
        res.add(CommandHandlerResultHandler.class);
        return res;
    }

    protected abstract List<String> getMandatoryCommands();

    protected abstract String getUnknownCommandHandlerIdentifier();

    protected abstract CommandHandler<Session> getUnknownCommandHandler();
}

