/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.api;

import java.util.LinkedList;
import java.util.List;
import org.apache.james.protocols.api.ExtensibleHandler;
import org.apache.james.protocols.api.ProtocolHandlerChain;
import org.apache.james.protocols.api.WiringException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProtocolHandlerChain
implements ProtocolHandlerChain {
    protected abstract List<Object> getHandlers();

    @Override
    public <T> LinkedList<T> getHandlers(Class<T> type) {
        LinkedList<Object> result = new LinkedList<Object>();
        List<Object> handlers = this.getHandlers();
        for (Object handler : handlers) {
            if (!type.isInstance(handler)) continue;
            result.add(handler);
        }
        return result;
    }

    public final void wireExtensibleHandlers() throws WiringException {
        List<Object> handlers = this.getHandlers();
        for (Object handler : handlers) {
            if (!(handler instanceof ExtensibleHandler)) continue;
            ExtensibleHandler extensibleHandler = (ExtensibleHandler)handler;
            List<Class<?>> markerInterfaces = extensibleHandler.getMarkerInterfaces();
            for (int i = 0; i < markerInterfaces.size(); ++i) {
                Class<?> markerInterface = markerInterfaces.get(i);
                LinkedList<?> extensions = this.getHandlers(markerInterface);
                extensibleHandler.wireExtensions(markerInterface, extensions);
            }
        }
    }
}

