/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.domainlist.jpa;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceException;
import javax.persistence.PersistenceUnit;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.domainlist.jpa.model.JPADomain;
import org.apache.james.domainlist.lib.AbstractDomainList;
import org.apache.james.lifecycle.api.Configurable;

public class JPADomainList
extends AbstractDomainList
implements Configurable {
    private EntityManagerFactory entityManagerFactory;

    @PersistenceUnit
    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    @PostConstruct
    public void init() {
        this.createEntityManager().close();
    }

    protected List<String> getDomainListInternal() throws DomainListException {
        List domains = new ArrayList();
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        EntityTransaction transaction = entityManager.getTransaction();
        try {
            transaction.begin();
            domains = entityManager.createNamedQuery("listDomainNames").getResultList();
            transaction.commit();
        }
        catch (PersistenceException e) {
            this.getLogger().error("Failed to list domains", (Throwable)e);
            if (transaction.isActive()) {
                transaction.rollback();
            }
            throw new DomainListException("Unable to retrieve domains", (Throwable)e);
        }
        finally {
            entityManager.close();
        }
        if (domains.size() == 0) {
            return null;
        }
        return new ArrayList<String>(domains);
    }

    public boolean containsDomain(String domain) throws DomainListException {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        EntityTransaction transaction = entityManager.getTransaction();
        try {
            transaction.begin();
            JPADomain jpaDomain = (JPADomain)entityManager.createNamedQuery("findDomainByName").setParameter("name", (Object)domain).getSingleResult();
            transaction.commit();
            boolean bl = jpaDomain != null;
            return bl;
        }
        catch (NoResultException e) {
            this.getLogger().debug("No domain found", (Throwable)e);
            transaction.commit();
            boolean bl = false;
            return bl;
        }
        catch (PersistenceException e) {
            this.getLogger().error("Failed to find domain", (Throwable)e);
            if (transaction.isActive()) {
                transaction.rollback();
            }
            throw new DomainListException("Unable to retrieve domains", (Throwable)e);
        }
        finally {
            entityManager.close();
        }
    }

    public void addDomain(String domain) throws DomainListException {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        EntityTransaction transaction = entityManager.getTransaction();
        try {
            transaction.begin();
            JPADomain jpaDomain = new JPADomain(domain);
            entityManager.persist((Object)jpaDomain);
            transaction.commit();
        }
        catch (PersistenceException e) {
            this.getLogger().error("Failed to save domain", (Throwable)e);
            if (transaction.isActive()) {
                transaction.rollback();
            }
            throw new DomainListException("Unable to add domain " + domain, (Throwable)e);
        }
        finally {
            entityManager.close();
        }
    }

    public void removeDomain(String domain) throws DomainListException {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        EntityTransaction transaction = entityManager.getTransaction();
        try {
            transaction.begin();
            entityManager.createNamedQuery("deleteDomainByName").setParameter("name", (Object)domain).executeUpdate();
            transaction.commit();
        }
        catch (PersistenceException e) {
            this.getLogger().error("Failed to remove domain", (Throwable)e);
            if (transaction.isActive()) {
                transaction.rollback();
            }
            throw new DomainListException("Unable to remove domain " + domain, (Throwable)e);
        }
        finally {
            entityManager.close();
        }
    }

    private EntityManager createEntityManager() {
        return this.entityManagerFactory.createEntityManager();
    }
}

