/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.container.spring.bean.factory.mailrepositorystore;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.CombinedConfiguration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.DefaultConfigurationBuilder;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.apache.james.container.spring.bean.AbstractBeanFactory;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.lifecycle.api.LogEnabled;
import org.apache.james.mailrepository.api.MailRepository;
import org.apache.james.mailrepository.api.MailRepositoryStore;
import org.slf4j.Logger;

public class MailRepositoryStoreBeanFactory
extends AbstractBeanFactory
implements MailRepositoryStore,
LogEnabled,
Configurable {
    private Map<String, MailRepository> repositories;
    private Map<String, String> classes;
    private Map<String, HierarchicalConfiguration> defaultConfigs;
    private HierarchicalConfiguration configuration;
    private Logger logger;

    public void configure(HierarchicalConfiguration configuration) throws ConfigurationException {
        this.configuration = configuration;
    }

    @PostConstruct
    public void init() throws Exception {
        this.getLogger().info("JamesMailStore init...");
        this.repositories = new ReferenceMap();
        this.classes = new HashMap<String, String>();
        this.defaultConfigs = new HashMap<String, HierarchicalConfiguration>();
        List registeredClasses = this.configuration.configurationsAt("mailrepositories.mailrepository");
        for (int i = 0; i < registeredClasses.size(); ++i) {
            this.registerRepository((HierarchicalConfiguration)registeredClasses.get(i));
        }
    }

    public synchronized void registerRepository(HierarchicalConfiguration repConf) throws ConfigurationException {
        String className = repConf.getString("[@class]");
        boolean infoEnabled = this.getLogger().isInfoEnabled();
        List protocols = repConf.getList("protocols.protocol");
        for (int i = 0; i < protocols.size(); ++i) {
            String protocol = (String)protocols.get(i);
            SubnodeConfiguration defConf = null;
            if (repConf.getKeys("config").hasNext()) {
                defConf = repConf.configurationAt("config");
            }
            String key = protocol;
            if (infoEnabled) {
                StringBuffer infoBuffer = new StringBuffer(128).append("Registering Repository instance of class ").append(className).append(" to handle ").append(protocol).append(" protocol requests for repositories with key ").append(key);
                this.getLogger().info(infoBuffer.toString());
            }
            if (this.classes.get(key) != null) {
                throw new ConfigurationException("The combination of protocol and type comprise a unique key for repositories.  This constraint has been violated.  Please check your repository configuration.");
            }
            this.classes.put(key, className);
            if (defConf == null) continue;
            this.defaultConfigs.put(key, (HierarchicalConfiguration)defConf);
        }
    }

    public synchronized MailRepository select(String destination) throws MailRepositoryStore.MailRepositoryStoreException {
        String protocol = null;
        int idx = destination.indexOf(58);
        if (idx == -1) {
            throw new MailRepositoryStore.MailRepositoryStoreException("Destination is malformed. Must be a valid URL: " + destination);
        }
        protocol = destination.substring(0, idx);
        String repID = destination;
        MailRepository reply = this.repositories.get(repID);
        StringBuffer logBuffer = null;
        if (reply != null) {
            if (this.getLogger().isDebugEnabled()) {
                logBuffer = new StringBuffer(128).append("obtained repository: ").append(repID).append(",").append(reply.getClass());
                this.getLogger().debug(logBuffer.toString());
            }
            return reply;
        }
        String key = protocol;
        String repClass = this.classes.get(key);
        if (this.getLogger().isDebugEnabled()) {
            logBuffer = new StringBuffer(128).append("obtained repository: ").append(repClass).append(" to handle: ").append(protocol).append(" with key ").append(key);
            this.getLogger().debug(logBuffer.toString());
        }
        CombinedConfiguration config = new CombinedConfiguration();
        HierarchicalConfiguration defConf = this.defaultConfigs.get(key);
        if (defConf != null) {
            config.addConfiguration((AbstractConfiguration)defConf);
        }
        DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
        builder.addProperty("[@destinationURL]", (Object)destination);
        config.addConfiguration((AbstractConfiguration)builder);
        try {
            Class<?> clazz = this.getBeanFactory().getBeanClassLoader().loadClass(repClass);
            reply = (MailRepository)this.getBeanFactory().autowire(clazz, 0, false);
            if (reply instanceof LogEnabled) {
                ((LogEnabled)reply).setLog(this.logger);
            }
            if (reply instanceof Configurable) {
                ((Configurable)reply).configure((HierarchicalConfiguration)config);
            }
            reply = (MailRepository)this.getBeanFactory().initializeBean((Object)reply, key);
            this.repositories.put(repID, reply);
            if (this.getLogger().isInfoEnabled()) {
                logBuffer = new StringBuffer(128).append("added repository: ").append(repID).append("->").append(repClass);
                this.getLogger().info(logBuffer.toString());
            }
            return reply;
        }
        catch (Exception e) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("Exception while creating repository:" + e.getMessage(), (Throwable)e);
            }
            throw new MailRepositoryStore.MailRepositoryStoreException("Cannot find or init repository", (Throwable)e);
        }
    }

    public synchronized List<String> getUrls() {
        return new ArrayList<String>(this.repositories.keySet());
    }

    public void setLog(Logger logger) {
        this.logger = logger;
    }

    private Logger getLogger() {
        return this.logger;
    }
}

