/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.container.spring.bean.factory.protocols;

import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.james.container.spring.bean.AbstractBeanFactory;
import org.apache.james.protocols.api.LifecycleAwareProtocolHandler;
import org.apache.james.protocols.api.ProtocolHandler;
import org.apache.james.protocols.api.ProtocolHandlerLoader;
import org.springframework.beans.BeansException;

public class ProtocolHandlerLoaderBeanFactory
extends AbstractBeanFactory
implements ProtocolHandlerLoader {
    public ProtocolHandler load(String name, Configuration config) throws ProtocolHandlerLoader.LoadingException {
        try {
            Class<?> c = this.getBeanFactory().getBeanClassLoader().loadClass(name);
            ProtocolHandler handler = (ProtocolHandler)this.getBeanFactory().createBean(c);
            if (handler instanceof LifecycleAwareProtocolHandler) {
                ((LifecycleAwareProtocolHandler)handler).init(config);
            }
            return handler;
        }
        catch (ClassNotFoundException e) {
            throw new ProtocolHandlerLoader.LoadingException("Unable to load handler", (Throwable)e);
        }
        catch (BeansException e) {
            throw new ProtocolHandlerLoader.LoadingException("Unable to load handler", (Throwable)e);
        }
        catch (ConfigurationException e) {
            throw new ProtocolHandlerLoader.LoadingException("Unable to load handler", (Throwable)e);
        }
    }
}

