/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.container.spring.bean.factorypostprocessor;

import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.container.spring.lifecycle.ConfigurationProvider;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;

public class MailboxConfigurationBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        ConfigurationProvider confProvider = (ConfigurationProvider)beanFactory.getBean(ConfigurationProvider.class);
        try {
            HierarchicalConfiguration config = confProvider.getConfiguration("mailbox");
            String provider = config.getString("provider", "jpa");
            BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
            String mailbox = null;
            String subscription = null;
            if (provider.equalsIgnoreCase("jpa")) {
                mailbox = "jpa-mailboxmanager";
                subscription = "jpa-subscriptionManager";
            } else if (provider.equalsIgnoreCase("memory")) {
                mailbox = "memory-mailboxmanager";
                subscription = "memory-subscriptionManager";
            } else if (provider.equalsIgnoreCase("jcr")) {
                mailbox = "jcr-mailboxmanager";
                subscription = "jcr-subscriptionManager";
            } else if (provider.equalsIgnoreCase("maildir")) {
                mailbox = "maildir-mailboxmanager";
                subscription = "maildir-subscriptionManager";
            }
            if (mailbox == null) {
                throw new ConfigurationException("Mailboxmanager provider " + provider + " not supported!");
            }
            registry.registerAlias(mailbox, "mailboxmanager");
            registry.registerAlias(subscription, "subscriptionManager");
        }
        catch (ConfigurationException e) {
            throw new FatalBeanException("Unable to config the mailboxmanager", (Throwable)e);
        }
    }
}

