/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.container.spring.context;

import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.james.container.spring.context.JamesServerApplicationContext;

public class JamesClassLoader
extends URLClassLoader {
    public JamesClassLoader(ClassLoader classLoader) {
        super(new URL[0], classLoader);
        String[] jars = new File(JamesServerApplicationContext.getResourceLoader().getExternalLibraryDirectory()).list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        if (jars != null) {
            for (int i = 0; i < jars.length; ++i) {
                File file = new File(JamesServerApplicationContext.getResourceLoader().getExternalLibraryDirectory() + jars[i]);
                try {
                    super.addURL(file.toURI().toURL());
                    continue;
                }
                catch (MalformedURLException e) {
                    System.out.println("Got an unexpected exception while building the urls for the james class loader for file " + file.getAbsolutePath());
                }
            }
        }
    }
}

