/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.container.spring.context;

import org.apache.james.container.spring.resource.AbstractJamesResourceLoader;
import org.apache.james.container.spring.resource.JamesResourceLoader;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.io.Resource;

public class JamesServerApplicationContext
extends ClassPathXmlApplicationContext
implements JamesResourceLoader {
    private static final JamesServerResourceLoader resourceLoader = new JamesServerResourceLoader();

    public JamesServerApplicationContext(String[] configs) {
        super(configs);
    }

    public Resource getResource(String fileURL) {
        Resource r = resourceLoader.getResource(fileURL);
        if (r == null) {
            r = super.getResource(fileURL);
        }
        return r;
    }

    @Override
    public String getAbsoluteDirectory() {
        return resourceLoader.getAbsoluteDirectory();
    }

    @Override
    public String getConfDirectory() {
        return resourceLoader.getConfDirectory();
    }

    @Override
    public String getVarDirectory() {
        return resourceLoader.getVarDirectory();
    }

    @Override
    public String getRootDirectory() {
        return resourceLoader.getRootDirectory();
    }

    protected static JamesServerResourceLoader getResourceLoader() {
        return resourceLoader;
    }

    protected static final class JamesServerResourceLoader
    extends AbstractJamesResourceLoader {
        protected JamesServerResourceLoader() {
        }

        @Override
        public String getAbsoluteDirectory() {
            return "/";
        }

        @Override
        public String getConfDirectory() {
            return this.getRootDirectory() + "/conf/";
        }

        @Override
        public String getVarDirectory() {
            return this.getRootDirectory() + "/var/";
        }

        public String getExternalLibraryDirectory() {
            return this.getRootDirectory() + "/conf/lib/";
        }

        @Override
        public String getRootDirectory() {
            return "../";
        }
    }
}

