/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.container.spring.context.web;

import org.apache.james.container.spring.resource.AbstractJamesResourceLoader;
import org.apache.james.container.spring.resource.JamesResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class JamesServerWebApplicationContext
extends XmlWebApplicationContext
implements JamesResourceLoader {
    private final JamesResourceLoader resourceLoader = new AbstractJamesResourceLoader(){

        @Override
        public String getAbsoluteDirectory() {
            if (JamesServerWebApplicationContext.this.absoluteDirectory == null) {
                return this.getRootDirectory();
            }
            return JamesServerWebApplicationContext.this.absoluteDirectory;
        }

        @Override
        public String getConfDirectory() {
            if (JamesServerWebApplicationContext.this.confDirectory == null) {
                return this.getRootDirectory() + "/WEB-INF/conf/";
            }
            return JamesServerWebApplicationContext.this.confDirectory;
        }

        @Override
        public String getRootDirectory() {
            if (JamesServerWebApplicationContext.this.rootDirectory == null) {
                return JamesServerWebApplicationContext.this.getServletContext().getRealPath("/");
            }
            return JamesServerWebApplicationContext.this.rootDirectory;
        }

        @Override
        public String getVarDirectory() {
            if (JamesServerWebApplicationContext.this.varDirectory == null) {
                return this.getRootDirectory() + "/var/";
            }
            return JamesServerWebApplicationContext.this.varDirectory;
        }
    };
    private String rootDirectory;
    private String absoluteDirectory;
    private String varDirectory;
    private String confDirectory;

    public Resource getResource(String fileURL) {
        Resource r = this.resourceLoader.getResource(fileURL);
        if (r == null) {
            r = super.getResource(fileURL);
        }
        return r;
    }

    public void setRootDirectory(String rootDirectory) {
        this.rootDirectory = rootDirectory;
    }

    public void setAbsoluteDirectory(String absoluteDirectory) {
        this.absoluteDirectory = absoluteDirectory;
    }

    public void setVarDirectory(String varDirectory) {
        this.varDirectory = varDirectory;
    }

    public void setConfDirectory(String confDirectory) {
        this.confDirectory = confDirectory;
    }

    @Override
    public String getAbsoluteDirectory() {
        return this.resourceLoader.getAbsoluteDirectory();
    }

    @Override
    public String getConfDirectory() {
        return this.resourceLoader.getConfDirectory();
    }

    @Override
    public String getVarDirectory() {
        return this.resourceLoader.getVarDirectory();
    }

    @Override
    public String getRootDirectory() {
        return this.resourceLoader.getRootDirectory();
    }
}

