/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.container.spring.filesystem;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.james.filesystem.api.FileSystem;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;

public class ResourceLoaderFileSystem
implements FileSystem,
ResourceLoaderAware {
    private ResourceLoader loader;

    public InputStream getResource(String url) throws IOException {
        return this.loader.getResource(url).getInputStream();
    }

    public File getFile(String fileURL) throws FileNotFoundException {
        try {
            return this.loader.getResource(fileURL).getFile();
        }
        catch (IOException e) {
            throw new FileNotFoundException("Could not load file " + fileURL);
        }
    }

    public File getBasedir() throws FileNotFoundException {
        try {
            return this.loader.getResource(".").getFile();
        }
        catch (IOException e) {
            throw new FileNotFoundException("Could not access basedirectory");
        }
    }

    public void setResourceLoader(ResourceLoader loader) {
        this.loader = loader;
    }
}

