/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.container.spring.mailbox;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.james.container.spring.mailbox.MailboxCopierManagementMBean;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.copier.MailboxCopier;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class MailboxCopierManagement
implements MailboxCopierManagementMBean,
ApplicationContextAware {
    private MailboxCopier copier;
    private ApplicationContext context;

    @Resource(name="mailboxcopier")
    public void setMailboxCopier(MailboxCopier copier) {
        this.copier = copier;
    }

    @Override
    public Map<String, String> getMailboxManagerBeans() {
        HashMap<String, String> bMap = new HashMap<String, String>();
        Map beans = this.context.getBeansOfType(MailboxManager.class);
        for (Map.Entry entry : beans.entrySet()) {
            String name = ((MailboxManager)entry.getValue()).getClass().getName();
            bMap.put((String)entry.getKey(), name);
        }
        return bMap;
    }

    @Override
    public void copy(String srcBean, String dstBean) throws Exception {
        if (srcBean.equals(dstBean)) {
            throw new IllegalArgumentException("srcBean and dstBean can not have the same name!");
        }
        try {
            this.copier.copyMailboxes((MailboxManager)this.context.getBean(srcBean, MailboxManager.class), (MailboxManager)this.context.getBean(dstBean, MailboxManager.class));
        }
        catch (BeansException e) {
            throw new Exception(e.getMessage());
        }
        catch (MailboxException e) {
            throw new Exception(e.getMessage());
        }
        catch (IOException e) {
            throw new Exception(e.getMessage());
        }
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
    }
}

