/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.container.spring.resource;

import java.io.File;
import org.apache.james.container.spring.resource.JamesResourceLoader;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public abstract class AbstractJamesResourceLoader
extends DefaultResourceLoader
implements JamesResourceLoader {
    public Resource getResource(String fileURL) {
        ClassPathResource r = null;
        if (fileURL.startsWith("classpath:")) {
            String resourceName = fileURL.substring("classpath:".length());
            r = new ClassPathResource(resourceName);
        } else if (fileURL.startsWith("file://")) {
            File file = null;
            file = fileURL.startsWith("file://conf/") ? new File(this.getConfDirectory() + "/" + fileURL.substring("file://conf/".length())) : (fileURL.startsWith("file://var/") ? new File(this.getVarDirectory() + "/" + fileURL.substring("file://var/".length())) : (fileURL.startsWith("file:///") ? new File(this.getAbsoluteDirectory() + fileURL.substring("file:///".length())) : new File(this.getRootDirectory() + "/" + fileURL.substring("file://".length()))));
            r = new FileSystemResource(file);
        } else {
            return null;
        }
        return r;
    }
}

