/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.container.spring.tool;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Iterator;
import javax.annotation.Resource;
import javax.mail.Flags;
import javax.mail.MessagingException;
import org.apache.james.core.MimeMessageInputStream;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.lifecycle.api.LogEnabled;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MailboxExistsException;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxPath;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailrepository.api.MailRepository;
import org.apache.james.mailrepository.api.MailRepositoryStore;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.mailet.Mail;
import org.slf4j.Logger;

public class James23Importer
implements LogEnabled {
    private Logger log;
    @Resource(name="usersrepository")
    private UsersRepository james30UsersRepository;
    @Resource(name="mailrepositorystore")
    private MailRepositoryStore mailRepositoryStore;
    @Resource(name="domainlist")
    private DomainList domainList;
    @Resource(name="mailboxmanager")
    private MailboxManager mailboxManager;
    @Resource(name="usersrepository23")
    private UsersRepository james23UsersRepository;

    public void importUsersAndMailsFromJames23(String james23MailRepositoryPath, String defaultPassword) throws MailRepositoryStore.MailRepositoryStoreException, MessagingException, UsersRepositoryException, DomainListException, MailboxException, IOException {
        this.importUsersFromJames23(defaultPassword);
        this.importMailsFromJames23(james23MailRepositoryPath);
    }

    public void importUsersFromJames23(String defaultPassword) throws MessagingException, UsersRepositoryException, DomainListException {
        Iterator j23uIt = this.james23UsersRepository.list();
        while (j23uIt.hasNext()) {
            String userName23 = (String)j23uIt.next();
            String userName30 = this.convert23UserTo30(userName23);
            this.james30UsersRepository.addUser(userName30, defaultPassword);
            this.log.info("New user is copied from 2.3 to 3.0 with username=" + userName30);
        }
    }

    public void importMailsFromJames23(String james23MailRepositoryPath) throws MessagingException, MailRepositoryStore.MailRepositoryStoreException, UsersRepositoryException, MailboxException, IOException, DomainListException {
        Flags flags = new Flags();
        boolean isRecent = false;
        Iterator james23userRepositoryIterator = this.james23UsersRepository.list();
        while (james23userRepositoryIterator.hasNext()) {
            String userName23 = (String)james23userRepositoryIterator.next();
            MailRepository mailRepository = this.mailRepositoryStore.select(james23MailRepositoryPath + "/" + userName23);
            Iterator mailRepositoryIterator = mailRepository.list();
            String userName30 = this.convert23UserTo30(userName23);
            MailboxSession mailboxSession = this.mailboxManager.createSystemSession(userName30, this.log);
            MailboxPath mailboxPath = MailboxPath.inbox((MailboxSession)mailboxSession);
            this.mailboxManager.startProcessingRequest(mailboxSession);
            try {
                this.mailboxManager.createMailbox(mailboxPath, mailboxSession);
            }
            catch (MailboxExistsException e) {
                // empty catch block
            }
            this.mailboxManager.endProcessingRequest(mailboxSession);
            MessageManager messageManager = this.mailboxManager.getMailbox(mailboxPath, mailboxSession);
            while (mailRepositoryIterator.hasNext()) {
                Mail mail = mailRepository.retrieve((String)mailRepositoryIterator.next());
                this.mailboxManager.startProcessingRequest(mailboxSession);
                messageManager.appendMessage((InputStream)new MimeMessageInputStream(mail.getMessage()), new Date(), mailboxSession, isRecent, flags);
                this.mailboxManager.endProcessingRequest(mailboxSession);
            }
        }
    }

    public void setLog(Logger log) {
        this.log = log;
    }

    private String convert23UserTo30(String userName23) throws DomainListException {
        return new String(userName23 + "@" + this.domainList.getDefaultDomain());
    }
}

