/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MailboxListener;
import org.apache.james.mailbox.MailboxListenerSupport;
import org.apache.james.mailbox.MailboxPath;
import org.apache.james.mailbox.MailboxSession;

public abstract class AbstractDelegatingMailboxListener
implements MailboxListener,
MailboxListenerSupport {
    private boolean isClosed = false;

    protected AbstractDelegatingMailboxListener() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void event(MailboxListener.Event event) {
        List<MailboxListener> globalListeners;
        Object l;
        int i;
        int sz;
        ArrayList<MailboxListener> closedListener;
        Map<MailboxPath, List<MailboxListener>> listeners;
        MailboxPath path = event.getMailboxPath();
        Map<MailboxPath, List<MailboxListener>> map = listeners = this.getListeners();
        synchronized (map) {
            List<MailboxListener> mListeners = listeners.get(path);
            if (mListeners != null && !mListeners.isEmpty()) {
                closedListener = new ArrayList<MailboxListener>();
                sz = mListeners.size();
                for (i = 0; i < sz; ++i) {
                    l = mListeners.get(i);
                    if (l.isClosed()) {
                        closedListener.add((MailboxListener)l);
                        continue;
                    }
                    l.event(event);
                }
                if (event instanceof MailboxListener.MailboxDeletion) {
                    listeners.remove(path);
                } else if (event instanceof MailboxListener.MailboxRenamed) {
                    MailboxListener.MailboxRenamed renamed = (MailboxListener.MailboxRenamed)event;
                    l = listeners.remove(path);
                    if (l != null) {
                        listeners.put(renamed.getNewPath(), (List<MailboxListener>)l);
                    }
                }
                if (!closedListener.isEmpty()) {
                    mListeners.removeAll(closedListener);
                    if (mListeners.isEmpty()) {
                        listeners.remove(path);
                    }
                }
            }
        }
        List<MailboxListener> list = globalListeners = this.getGlobalListeners();
        synchronized (list) {
            if (globalListeners != null && !globalListeners.isEmpty()) {
                closedListener = new ArrayList();
                sz = globalListeners.size();
                for (i = 0; i < sz; ++i) {
                    l = globalListeners.get(i);
                    if (l.isClosed()) {
                        closedListener.add((MailboxListener)l);
                        continue;
                    }
                    l.event(event);
                }
                if (!closedListener.isEmpty()) {
                    globalListeners.removeAll(closedListener);
                }
            }
        }
    }

    public synchronized void close() {
        this.isClosed = true;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(MailboxPath path, MailboxListener listener, MailboxSession session) throws MailboxException {
        Map<MailboxPath, List<MailboxListener>> listeners;
        Map<MailboxPath, List<MailboxListener>> map = listeners = this.getListeners();
        synchronized (map) {
            List<MailboxListener> mListeners = listeners.get(path);
            if (mListeners == null) {
                mListeners = new ArrayList<MailboxListener>();
                listeners.put(path, mListeners);
            }
            if (!mListeners.contains(listener)) {
                mListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGlobalListener(MailboxListener listener, MailboxSession session) throws MailboxException {
        List<MailboxListener> gListeners;
        List<MailboxListener> list = gListeners = this.getGlobalListeners();
        synchronized (list) {
            gListeners.add(listener);
        }
    }

    protected abstract Map<MailboxPath, List<MailboxListener>> getListeners();

    protected abstract List<MailboxListener> getGlobalListeners();
}

