/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MailboxPath;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.store.AbstractMailboxPathLocker;

public final class JVMMailboxPathLocker
extends AbstractMailboxPathLocker {
    private final ConcurrentHashMap<MailboxPath, Lock> paths = new ConcurrentHashMap();

    @Override
    protected void lock(MailboxSession session, MailboxPath path) throws MailboxException {
        Lock storedLock;
        Lock lock = this.paths.get(path);
        if (lock == null && (storedLock = this.paths.putIfAbsent(path, lock = new ReentrantLock())) != null) {
            lock = storedLock;
        }
        lock.lock();
    }

    @Override
    protected void unlock(MailboxSession session, MailboxPath path) throws MailboxException {
        Lock lock = this.paths.get(path);
        if (lock != null) {
            lock.unlock();
        }
    }
}

