/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.james.mailbox.MailboxListener;
import org.apache.james.mailbox.MailboxPath;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageMetaData;
import org.apache.james.mailbox.UpdatedFlags;
import org.apache.james.mailbox.store.StoreMailboxPath;
import org.apache.james.mailbox.store.mail.model.Mailbox;

public class MailboxEventDispatcher<Id>
implements MailboxListener {
    private final Set<MailboxListener> listeners = new CopyOnWriteArraySet<MailboxListener>();

    private void pruneClosed() {
        ArrayList<MailboxListener> closedListeners = new ArrayList<MailboxListener>();
        for (MailboxListener listener : this.listeners) {
            if (!listener.isClosed()) continue;
            closedListeners.add(listener);
        }
        if (!closedListeners.isEmpty()) {
            this.listeners.removeAll(closedListeners);
        }
    }

    public void addMailboxListener(MailboxListener mailboxListener) {
        this.pruneClosed();
        this.listeners.add(mailboxListener);
    }

    public void added(MailboxSession session, Map<Long, MessageMetaData> uids, Mailbox<Id> mailbox) {
        this.pruneClosed();
        AddedImpl added = new AddedImpl(session, mailbox, uids);
        this.event((MailboxListener.Event)added);
    }

    public void expunged(MailboxSession session, Map<Long, MessageMetaData> uids, Mailbox<Id> mailbox) {
        ExpungedImpl expunged = new ExpungedImpl(session, mailbox, uids);
        this.event((MailboxListener.Event)expunged);
    }

    public void flagsUpdated(MailboxSession session, List<Long> uids, Mailbox<Id> mailbox, List<UpdatedFlags> uflags) {
        FlagsUpdatedImpl flags = new FlagsUpdatedImpl(session, mailbox, uids, uflags);
        this.event((MailboxListener.Event)flags);
    }

    public void event(MailboxListener.Event event) {
        ArrayList<MailboxListener> closed = new ArrayList<MailboxListener>();
        for (MailboxListener mailboxListener : this.listeners) {
            if (!mailboxListener.isClosed()) {
                mailboxListener.event(event);
                continue;
            }
            closed.add(mailboxListener);
        }
        for (int i = 0; i < closed.size(); ++i) {
            this.listeners.remove(closed.get(i));
        }
    }

    public int count() {
        return this.listeners.size();
    }

    public void mailboxRenamed(MailboxSession session, MailboxPath from, Mailbox<Id> to) {
        this.event((MailboxListener.Event)new MailboxRenamedEventImpl(session, from, to));
    }

    public void mailboxDeleted(MailboxSession session, Mailbox<Id> mailbox) {
        MailboxDeletionImpl event = new MailboxDeletionImpl(session, mailbox);
        this.event((MailboxListener.Event)event);
    }

    public void mailboxAdded(MailboxSession session, Mailbox<Id> mailbox) {
        MailboxAddedImpl event = new MailboxAddedImpl(session, mailbox);
        this.event((MailboxListener.Event)event);
    }

    public boolean isClosed() {
        return false;
    }

    public final class MailboxRenamedEventImpl
    extends MailboxListener.MailboxRenamed {
        private final MailboxPath newPath;
        private final Mailbox<Id> newMailbox;

        public MailboxRenamedEventImpl(MailboxSession session, MailboxPath oldPath, Mailbox<Id> newMailbox) {
            super(session, oldPath);
            this.newPath = new StoreMailboxPath(newMailbox);
            this.newMailbox = newMailbox;
        }

        public MailboxPath getNewPath() {
            return this.newPath;
        }

        public Mailbox<Id> getNewMailbox() {
            return this.newMailbox;
        }
    }

    public final class MailboxAddedImpl
    extends MailboxListener.MailboxAdded {
        private final Mailbox<Id> mailbox;

        public MailboxAddedImpl(MailboxSession session, Mailbox<Id> mailbox) {
            super(session, new StoreMailboxPath(mailbox));
            this.mailbox = mailbox;
        }

        public Mailbox<Id> getMailbox() {
            return this.mailbox;
        }
    }

    public final class MailboxDeletionImpl
    extends MailboxListener.MailboxDeletion {
        private final Mailbox<Id> mailbox;

        public MailboxDeletionImpl(MailboxSession session, Mailbox<Id> mailbox) {
            super(session, new StoreMailboxPath(mailbox));
            this.mailbox = mailbox;
        }

        public Mailbox<Id> getMailbox() {
            return this.mailbox;
        }
    }

    public final class FlagsUpdatedImpl
    extends MailboxListener.FlagsUpdated {
        private final List<Long> uids;
        private final Mailbox<Id> mailbox;
        private final List<UpdatedFlags> uFlags;

        public FlagsUpdatedImpl(MailboxSession session, Mailbox<Id> mailbox, List<Long> uids, List<UpdatedFlags> uFlags) {
            super(session, new StoreMailboxPath(mailbox));
            this.uids = uids;
            this.uFlags = uFlags;
            this.mailbox = mailbox;
        }

        public List<Long> getUids() {
            return this.uids;
        }

        public List<UpdatedFlags> getUpdatedFlags() {
            return this.uFlags;
        }

        public Mailbox<Id> getMailbox() {
            return this.mailbox;
        }
    }

    public final class ExpungedImpl
    extends MailboxListener.Expunged {
        private final Map<Long, MessageMetaData> uids;
        private final Mailbox<Id> mailbox;

        public ExpungedImpl(MailboxSession session, Mailbox<Id> mailbox, Map<Long, MessageMetaData> uids) {
            super(session, new StoreMailboxPath(mailbox));
            this.uids = uids;
            this.mailbox = mailbox;
        }

        public List<Long> getUids() {
            return new ArrayList<Long>(this.uids.keySet());
        }

        public MessageMetaData getMetaData(long uid) {
            return this.uids.get(uid);
        }

        public Mailbox<Id> getMailbox() {
            return this.mailbox;
        }
    }

    public final class AddedImpl
    extends MailboxListener.Added {
        private Map<Long, MessageMetaData> added;
        private final Mailbox<Id> mailbox;

        public AddedImpl(MailboxSession session, Mailbox<Id> mailbox, Map<Long, MessageMetaData> added) {
            super(session, new StoreMailboxPath(mailbox));
            this.added = added;
            this.mailbox = mailbox;
        }

        public List<Long> getUids() {
            return new ArrayList<Long>(this.added.keySet());
        }

        public MessageMetaData getMetaData(long uid) {
            return this.added.get(uid);
        }

        public Mailbox<Id> getMailbox() {
            return this.mailbox;
        }
    }
}

