/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import java.util.ArrayList;
import java.util.List;
import javax.mail.Flags;
import org.apache.james.mailbox.MessageManager;

public class MailboxMetaData
implements MessageManager.MetaData {
    private final long recentCount;
    private final List<Long> recent;
    private final Flags premanentFlags;
    private final long uidValidity;
    private final long nextUid;
    private final long messageCount;
    private final long unseenCount;
    private final Long firstUnseen;
    private final boolean writeable;
    private final long highestModSeq;
    private final boolean modSeqPermanent;

    public MailboxMetaData(List<Long> recent, Flags premanentFlags, long uidValidity, long nextUid, long highestModSeq, long messageCount, long unseenCount, Long firstUnseen, boolean writeable, boolean modSeqPermanent) {
        this.recent = recent == null ? new ArrayList<Long>() : recent;
        this.highestModSeq = highestModSeq;
        this.recentCount = recent.size();
        this.premanentFlags = premanentFlags;
        this.uidValidity = uidValidity;
        this.nextUid = nextUid;
        this.messageCount = messageCount;
        this.unseenCount = unseenCount;
        this.firstUnseen = firstUnseen;
        this.writeable = writeable;
        this.modSeqPermanent = modSeqPermanent;
    }

    public long countRecent() {
        return this.recentCount;
    }

    public Flags getPermanentFlags() {
        return this.premanentFlags;
    }

    public List<Long> getRecent() {
        return this.recent;
    }

    public long getUidValidity() {
        return this.uidValidity;
    }

    public long getUidNext() {
        return this.nextUid;
    }

    public long getMessageCount() {
        return this.messageCount;
    }

    public long getUnseenCount() {
        return this.unseenCount;
    }

    public Long getFirstUnseen() {
        return this.firstUnseen;
    }

    public boolean isWriteable() {
        return this.writeable;
    }

    public long getHighestModSeq() {
        return this.highestModSeq;
    }

    public boolean isModSeqPermanent() {
        return this.modSeqPermanent;
    }
}

