/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.RequestAware;
import org.apache.james.mailbox.SubscriptionException;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.apache.james.mailbox.store.mail.MailboxMapperFactory;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.MessageMapperFactory;
import org.apache.james.mailbox.store.user.SubscriptionMapper;
import org.apache.james.mailbox.store.user.SubscriptionMapperFactory;

public abstract class MailboxSessionMapperFactory<Id>
implements RequestAware,
MailboxMapperFactory<Id>,
MessageMapperFactory<Id>,
SubscriptionMapperFactory {
    protected static final String MESSAGEMAPPER = "MESSAGEMAPPER";
    protected static final String MAILBOXMAPPER = "MAILBOXMAPPER";
    protected static final String SUBSCRIPTIONMAPPER = "SUBSCRIPTIONMAPPER";

    @Override
    public MessageMapper<Id> getMessageMapper(MailboxSession session) throws MailboxException {
        MessageMapper<Id> mapper = (MessageMapper<Id>)session.getAttributes().get(MESSAGEMAPPER);
        if (mapper == null) {
            mapper = this.createMessageMapper(session);
            session.getAttributes().put(MESSAGEMAPPER, mapper);
        }
        return mapper;
    }

    protected abstract MessageMapper<Id> createMessageMapper(MailboxSession var1) throws MailboxException;

    @Override
    public MailboxMapper<Id> getMailboxMapper(MailboxSession session) throws MailboxException {
        MailboxMapper<Id> mapper = (MailboxMapper<Id>)session.getAttributes().get(MAILBOXMAPPER);
        if (mapper == null) {
            mapper = this.createMailboxMapper(session);
            session.getAttributes().put(MAILBOXMAPPER, mapper);
        }
        return mapper;
    }

    protected abstract MailboxMapper<Id> createMailboxMapper(MailboxSession var1) throws MailboxException;

    @Override
    public SubscriptionMapper getSubscriptionMapper(MailboxSession session) throws SubscriptionException {
        SubscriptionMapper mapper = (SubscriptionMapper)session.getAttributes().get(SUBSCRIPTIONMAPPER);
        if (mapper == null) {
            mapper = this.createSubscriptionMapper(session);
            session.getAttributes().put(SUBSCRIPTIONMAPPER, mapper);
        }
        return mapper;
    }

    protected abstract SubscriptionMapper createSubscriptionMapper(MailboxSession var1) throws SubscriptionException;

    public void endProcessingRequest(MailboxSession session) {
        if (session == null) {
            return;
        }
        MessageMapper messageMapper = (MessageMapper)session.getAttributes().get(MESSAGEMAPPER);
        MailboxMapper mailboxMapper = (MailboxMapper)session.getAttributes().get(MAILBOXMAPPER);
        SubscriptionMapper subscriptionMapper = (SubscriptionMapper)session.getAttributes().get(SUBSCRIPTIONMAPPER);
        if (messageMapper != null) {
            messageMapper.endRequest();
        }
        if (mailboxMapper != null) {
            mailboxMapper.endRequest();
        }
        if (subscriptionMapper != null) {
            subscriptionMapper.endRequest();
        }
    }

    public void startProcessingRequest(MailboxSession session) {
    }
}

