/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.mail.Flags;
import org.apache.james.mailbox.Content;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MessageResult;
import org.apache.james.mailbox.MimeDescriptor;

public class MessageResultImpl
implements MessageResult {
    private long uid;
    private Flags flags;
    private int size;
    private Date internalDate;
    private List<MessageResult.Header> headers;
    private Content body;
    private Content fullContent;
    private int includedResults = 0;
    private Map<MessageResult.MimePath, PartContent> partsByPath = new HashMap<MessageResult.MimePath, PartContent>();
    private MimeDescriptor mimeDescriptor;
    private long modSeq;

    public MessageResultImpl(long uid) {
        this.setUid(uid);
    }

    public MessageResultImpl() {
    }

    public MessageResultImpl(long uid, Flags flags) {
        this.setUid(uid);
        this.setFlags(flags);
    }

    public long getUid() {
        return this.uid;
    }

    public Date getInternalDate() {
        return this.internalDate;
    }

    public Flags getFlags() {
        return this.flags;
    }

    public void setUid(long uid) {
        this.uid = uid;
    }

    public long getSize() {
        return this.size;
    }

    public void setFlags(Flags flags) {
        this.flags = flags;
    }

    public int compareTo(MessageResult that) {
        if (this.uid > 0L && that.getUid() > 0L) {
            return Long.valueOf(this.uid).compareTo(that.getUid());
        }
        throw new RuntimeException("can't compare");
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setInternalDate(Date internalDate) {
        this.internalDate = internalDate;
    }

    public Iterator<MessageResult.Header> headers() {
        if (this.headers == null) {
            return null;
        }
        return this.headers.iterator();
    }

    public List<MessageResult.Header> getHeaders() {
        return this.headers;
    }

    public void setHeaders(List<MessageResult.Header> headers) {
        this.headers = headers;
        if (headers != null) {
            this.includedResults |= 0x100;
        }
    }

    public final Content getFullContent() {
        return this.fullContent;
    }

    public final void setFullContent(Content fullMessage) {
        this.fullContent = fullMessage;
        if (fullMessage != null) {
            this.includedResults |= 0x200;
        }
    }

    public final Content getBody() {
        return this.body;
    }

    public final void setBody(Content messageBody) {
        this.body = messageBody;
        if (messageBody != null) {
            this.includedResults |= 0x400;
        }
    }

    public String toString() {
        String TAB = " ";
        String retValue = "MessageResultImpl ( uid = " + this.uid + " " + "flags = " + this.flags + " " + "size = " + this.size + " " + "internalDate = " + this.internalDate + " " + "includedResults = " + this.includedResults + " " + " )";
        return retValue;
    }

    public Content getBody(MessageResult.MimePath path) throws MailboxException {
        PartContent partContent = this.getPartContent(path);
        Content result = partContent == null ? null : partContent.getBody();
        return result;
    }

    public Content getMimeBody(MessageResult.MimePath path) throws MailboxException {
        PartContent partContent = this.getPartContent(path);
        Content result = partContent == null ? null : partContent.getMimeBody();
        return result;
    }

    public Content getFullContent(MessageResult.MimePath path) throws MailboxException {
        PartContent partContent = this.getPartContent(path);
        Content result = partContent == null ? null : partContent.getFull();
        return result;
    }

    public Iterator<MessageResult.Header> iterateHeaders(MessageResult.MimePath path) throws MailboxException {
        PartContent partContent = this.getPartContent(path);
        Iterator<MessageResult.Header> result = partContent == null ? null : partContent.getHeaders();
        return result;
    }

    public Iterator<MessageResult.Header> iterateMimeHeaders(MessageResult.MimePath path) throws MailboxException {
        PartContent partContent = this.getPartContent(path);
        Iterator<MessageResult.Header> result = partContent == null ? null : partContent.getMimeHeaders();
        return result;
    }

    public void setBodyContent(MessageResult.MimePath path, Content content) {
        PartContent partContent = this.getPartContent(path);
        partContent.setBody(content);
    }

    public void setMimeBodyContent(MessageResult.MimePath path, Content content) {
        PartContent partContent = this.getPartContent(path);
        partContent.setMimeBody(content);
    }

    public void setFullContent(MessageResult.MimePath path, Content content) {
        PartContent partContent = this.getPartContent(path);
        partContent.setFull(content);
    }

    public void setHeaders(MessageResult.MimePath path, Iterator<MessageResult.Header> headers) {
        PartContent partContent = this.getPartContent(path);
        partContent.setHeaders(headers);
    }

    public void setMimeHeaders(MessageResult.MimePath path, Iterator<MessageResult.Header> headers) {
        PartContent partContent = this.getPartContent(path);
        partContent.setMimeHeaders(headers);
    }

    private PartContent getPartContent(MessageResult.MimePath path) {
        PartContent result = this.partsByPath.get(path);
        if (result == null) {
            result = new PartContent();
            this.partsByPath.put(path, result);
        }
        return result;
    }

    public void setMimeDescriptor(MimeDescriptor mimeDescriptor) {
        this.includedResults |= 1;
        this.mimeDescriptor = mimeDescriptor;
    }

    public MimeDescriptor getMimeDescriptor() {
        return this.mimeDescriptor;
    }

    public long getModSeq() {
        return this.modSeq;
    }

    public void setModSeq(long modSeq) {
        this.modSeq = modSeq;
    }

    private static final class PartContent {
        private Content body;
        private Content mimeBody;
        private Content full;
        private Iterator<MessageResult.Header> headers;
        private Iterator<MessageResult.Header> mimeHeaders;
        private int content;

        private PartContent() {
        }

        public Content getBody() {
            return this.body;
        }

        public void setBody(Content body) {
            this.content |= 0x400;
            this.body = body;
        }

        public Content getMimeBody() {
            return this.mimeBody;
        }

        public void setMimeBody(Content mimeBody) {
            this.content |= 0x1000;
            this.mimeBody = mimeBody;
        }

        public Content getFull() {
            return this.full;
        }

        public void setFull(Content full) {
            this.content |= 0x200;
            this.full = full;
        }

        public Iterator<MessageResult.Header> getHeaders() {
            return this.headers;
        }

        public void setHeaders(Iterator<MessageResult.Header> headers) {
            this.content |= 0x100;
            this.headers = headers;
        }

        public Iterator<MessageResult.Header> getMimeHeaders() {
            return this.mimeHeaders;
        }

        public void setMimeHeaders(Iterator<MessageResult.Header> mimeHeaders) {
            this.content |= 0x800;
            this.mimeHeaders = mimeHeaders;
        }
    }
}

