/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.james.mailbox.MessageResult;
import org.apache.james.mailbox.MimeDescriptor;
import org.apache.james.mailbox.store.ResultHeader;
import org.apache.james.mailbox.store.ResultUtils;
import org.apache.james.mailbox.store.mail.model.Message;
import org.apache.james.mailbox.store.mail.model.Property;
import org.apache.james.mailbox.store.mail.model.impl.PropertyBuilder;
import org.apache.james.mailbox.store.streaming.ConfigurableMimeTokenStream;
import org.apache.james.mailbox.store.streaming.CountingInputStream;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.descriptor.MaximalBodyDescriptor;
import org.apache.james.mime4j.parser.MimeEntityConfig;
import org.apache.james.mime4j.parser.MimeTokenStream;

public class MimeDescriptorImpl
implements MimeDescriptor {
    private final long bodyOctets;
    private final String contentDescription;
    private final String contentId;
    private final long lines;
    private final String subType;
    private final String type;
    private final String transferEncoding;
    private final List<String> languages;
    private final Collection<MessageResult.Header> headers;
    private final Map<String, String> contentTypeParameters;
    private final String disposition;
    private final Map<String, String> dispositionParams;
    private final MimeDescriptor embeddedMessage;
    private final Collection<MimeDescriptor> parts;
    private final String location;
    private final String md5;

    public static MimeDescriptorImpl build(Message<?> document) throws IOException, MimeException {
        MimeDescriptorImpl result;
        String mediaType = document.getMediaType();
        if (MimeDescriptorImpl.isComposite(mediaType)) {
            result = MimeDescriptorImpl.build(ResultUtils.toInput(document));
        } else {
            List<MessageResult.Header> headers = ResultUtils.createHeaders(document);
            List<Property> properties = document.getProperties();
            PropertyBuilder builder = new PropertyBuilder(properties);
            Long textualLineCount = document.getTextualLineCount();
            result = new MimeDescriptorImpl(document.getBodyOctets(), builder.getContentDescription(), builder.getContentID(), textualLineCount == null ? -1L : textualLineCount, document.getSubType(), mediaType, builder.getContentTransferEncoding(), headers, builder.getContentTypeParameters(), builder.getContentLanguage(), builder.getContentDispositionType(), builder.getContentDispositionParameters(), null, new ArrayList<MimeDescriptor>(), builder.getContentLocation(), builder.getContentMD5());
        }
        return result;
    }

    public static boolean isComposite(String mediaType) {
        return "message".equalsIgnoreCase(mediaType) || "multipart".equalsIgnoreCase(mediaType);
    }

    public static MimeDescriptorImpl build(InputStream stream) throws IOException, MimeException {
        MimeEntityConfig config = new MimeEntityConfig();
        config.setMaximalBodyDescriptor(true);
        config.setMaxLineLen(-1);
        ConfigurableMimeTokenStream parser = new ConfigurableMimeTokenStream(config);
        parser.parse(stream);
        parser.setRecursionMode(1);
        return MimeDescriptorImpl.createDescriptor(parser);
    }

    private static MimeDescriptorImpl createDescriptor(MimeTokenStream parser) throws IOException, MimeException {
        MimeDescriptorImpl mimeDescriptorImpl;
        int next = parser.next();
        ArrayList<MessageResult.Header> headers = new ArrayList<MessageResult.Header>();
        while (next != 12 && next != -1 && next != 6) {
            if (next == 4) {
                headers.add(new ResultHeader(parser.getField().getName(), parser.getField().getBody().trim()));
            }
            next = parser.next();
        }
        switch (next) {
            case 12: {
                mimeDescriptorImpl = MimeDescriptorImpl.simplePartDescriptor(parser, headers);
                break;
            }
            case 6: {
                mimeDescriptorImpl = MimeDescriptorImpl.compositePartDescriptor(parser, headers);
                break;
            }
            case -1: {
                throw new MimeException("Premature end of stream");
            }
            default: {
                throw new MimeException("Unexpected parse state");
            }
        }
        return mimeDescriptorImpl;
    }

    private static MimeDescriptorImpl compositePartDescriptor(MimeTokenStream parser, Collection<MessageResult.Header> headers) throws IOException, MimeException {
        MaximalBodyDescriptor descriptor = (MaximalBodyDescriptor)parser.getBodyDescriptor();
        MimeDescriptorImpl mimeDescriptor = MimeDescriptorImpl.createDescriptor(0L, 0L, descriptor, null, headers);
        int next = parser.next();
        while (next != 7 && next != -1) {
            if (next == 10) {
                mimeDescriptor.addPart(MimeDescriptorImpl.createDescriptor(parser));
            }
            next = parser.next();
        }
        return mimeDescriptor;
    }

    private static MimeDescriptorImpl simplePartDescriptor(MimeTokenStream parser, Collection<MessageResult.Header> headers) throws IOException, MimeException {
        MimeDescriptorImpl mimeDescriptorImpl;
        MaximalBodyDescriptor descriptor = (MaximalBodyDescriptor)parser.getBodyDescriptor();
        if ("message".equalsIgnoreCase(descriptor.getMediaType()) && "rfc822".equalsIgnoreCase(descriptor.getSubType())) {
            CountingInputStream messageStream = new CountingInputStream(parser.getDecodedInputStream());
            MimeDescriptorImpl embeddedMessageDescriptor = MimeDescriptorImpl.build(messageStream);
            int octetCount = messageStream.getOctetCount();
            int lineCount = messageStream.getLineCount();
            mimeDescriptorImpl = MimeDescriptorImpl.createDescriptor(octetCount, lineCount, descriptor, embeddedMessageDescriptor, headers);
        } else {
            InputStream body = parser.getInputStream();
            long bodyOctets = 0L;
            long lines = 0L;
            int n = body.read();
            while (n >= 0) {
                if (n == 13) {
                    ++lines;
                }
                ++bodyOctets;
                n = body.read();
            }
            mimeDescriptorImpl = MimeDescriptorImpl.createDescriptor(bodyOctets, lines, descriptor, null, headers);
        }
        return mimeDescriptorImpl;
    }

    private static MimeDescriptorImpl createDescriptor(long bodyOctets, long lines, MaximalBodyDescriptor descriptor, MimeDescriptor embeddedMessage, Collection<MessageResult.Header> headers) {
        String boundary;
        String contentDescription = descriptor.getContentDescription();
        String contentId = descriptor.getContentId();
        String subType = descriptor.getSubType();
        String type = descriptor.getMediaType();
        String transferEncoding = descriptor.getTransferEncoding();
        TreeMap<String, String> contentTypeParameters = new TreeMap<String, String>(descriptor.getContentTypeParameters());
        String codeset = descriptor.getCharset();
        if (codeset == null) {
            if ("TEXT".equals(type)) {
                contentTypeParameters.put("charset", "us-ascii");
            }
        } else {
            contentTypeParameters.put("charset", codeset);
        }
        if ((boundary = descriptor.getBoundary()) != null) {
            contentTypeParameters.put("boundary", boundary);
        }
        List languages = descriptor.getContentLanguage();
        String disposition = descriptor.getContentDispositionType();
        Map dispositionParams = descriptor.getContentDispositionParameters();
        ArrayList<MimeDescriptor> parts = new ArrayList<MimeDescriptor>();
        String location = descriptor.getContentLocation();
        String md5 = descriptor.getContentMD5Raw();
        MimeDescriptorImpl mimeDescriptorImpl = new MimeDescriptorImpl(bodyOctets, contentDescription, contentId, lines, subType, type, transferEncoding, headers, contentTypeParameters, languages, disposition, dispositionParams, embeddedMessage, parts, location, md5);
        return mimeDescriptorImpl;
    }

    public MimeDescriptorImpl(long bodyOctets, String contentDescription, String contentId, long lines, String subType, String type, String transferEncoding, Collection<MessageResult.Header> headers, Map<String, String> contentTypeParameters, List<String> languages, String disposition, Map<String, String> dispositionParams, MimeDescriptor embeddedMessage, Collection<MimeDescriptor> parts, String location, String md5) {
        this.type = type;
        this.bodyOctets = bodyOctets;
        this.contentDescription = contentDescription;
        this.contentId = contentId;
        this.lines = lines;
        this.subType = subType;
        this.transferEncoding = transferEncoding;
        this.headers = headers;
        this.contentTypeParameters = contentTypeParameters;
        this.embeddedMessage = embeddedMessage;
        this.parts = parts;
        this.languages = languages;
        this.disposition = disposition;
        this.dispositionParams = dispositionParams;
        this.location = location;
        this.md5 = md5;
    }

    public Map<String, String> contentTypeParameters() {
        return this.contentTypeParameters;
    }

    public MimeDescriptor embeddedMessage() {
        return this.embeddedMessage;
    }

    public long getBodyOctets() {
        return this.bodyOctets;
    }

    public String getContentDescription() {
        return this.contentDescription;
    }

    public String getContentID() {
        return this.contentId;
    }

    public long getLines() {
        return this.lines;
    }

    public String getMimeSubType() {
        return this.subType;
    }

    public String getMimeType() {
        return this.type;
    }

    public String getTransferContentEncoding() {
        return this.transferEncoding;
    }

    public Iterator<MessageResult.Header> headers() {
        return this.headers.iterator();
    }

    public Iterator<MimeDescriptor> parts() {
        return this.parts.iterator();
    }

    private void addPart(MimeDescriptor descriptor) {
        this.parts.add(descriptor);
    }

    public List<String> getLanguages() {
        return this.languages;
    }

    public String getDisposition() {
        return this.disposition;
    }

    public Map<String, String> getDispositionParams() {
        return this.dispositionParams;
    }

    public String getContentLocation() {
        return this.location;
    }

    public String getContentMD5() {
        return this.md5;
    }
}

