/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import org.apache.james.mailbox.InputStreamContent;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MessageResult;
import org.apache.james.mailbox.store.ResultUtils;

public final class ResultHeader
implements MessageResult.Header,
InputStreamContent {
    private final String name;
    private final String value;
    private final long size;

    public ResultHeader(String name, String value) {
        this.name = name;
        this.value = value;
        this.size = name.length() + value.length() + 2;
    }

    public String getName() throws MailboxException {
        return this.name;
    }

    public String getValue() throws MailboxException {
        return this.value;
    }

    public long size() {
        return this.size;
    }

    public void writeTo(WritableByteChannel channel) throws IOException {
        this.writeAll(channel, ResultUtils.US_ASCII.encode(this.name));
        ByteBuffer buffer = ByteBuffer.wrap(ResultUtils.BYTES_HEADER_FIELD_VALUE_SEP);
        this.writeAll(channel, buffer);
        this.writeAll(channel, ResultUtils.US_ASCII.encode(this.value));
    }

    private void writeAll(WritableByteChannel channel, ByteBuffer buffer) throws IOException {
        while (channel.write(buffer) > 0) {
        }
    }

    public String toString() {
        return "[HEADER " + this.name + ": " + this.value + "]";
    }

    public InputStream getInputStream() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.writeTo(Channels.newChannel(out));
        return new ByteArrayInputStream(out.toByteArray());
    }
}

