/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.mail.Flags;
import org.apache.james.mailbox.Content;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MessageResult;
import org.apache.james.mailbox.MimeDescriptor;
import org.apache.james.mailbox.store.ResultUtils;
import org.apache.james.mailbox.store.mail.model.Message;

public class ResultIterator<Id>
implements Iterator<MessageResult> {
    private final Iterator<Message<Id>> messages;
    private final MessageResult.FetchGroup fetchGroup;

    public ResultIterator(Iterator<Message<Id>> messages, MessageResult.FetchGroup fetchGroup) {
        this.messages = messages == null ? new ArrayList().iterator() : messages;
        this.fetchGroup = fetchGroup;
    }

    @Override
    public boolean hasNext() {
        return this.messages.hasNext();
    }

    @Override
    public MessageResult next() {
        UnloadedMessageResult<Id> result;
        if (!this.hasNext()) {
            throw new NoSuchElementException("No such element.");
        }
        Message<Id> message = this.messages.next();
        try {
            result = ResultUtils.loadMessageResult(message, this.fetchGroup);
        }
        catch (MailboxException e) {
            result = new UnloadedMessageResult<Id>(message, e);
        }
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Read only iteration.");
    }

    private static final class UnloadedMessageResult<Id>
    implements MessageResult {
        private final MailboxException exception;
        private final Date internalDate;
        private final long size;
        private final long uid;
        private final Flags flags;
        private long modSeq = -1L;

        public UnloadedMessageResult(Message<Id> message, MailboxException exception) {
            this.internalDate = message.getInternalDate();
            this.size = message.getFullContentOctets();
            this.uid = message.getUid();
            this.flags = message.createFlags();
            this.modSeq = message.getModSeq();
            this.exception = exception;
        }

        public Flags getFlags() {
            return this.flags;
        }

        public Content getFullContent() throws MailboxException {
            throw this.exception;
        }

        public Date getInternalDate() {
            return this.internalDate;
        }

        public Content getBody() throws MailboxException {
            throw this.exception;
        }

        public long getSize() {
            return this.size;
        }

        public long getUid() {
            return this.uid;
        }

        public Iterator<MessageResult.Header> headers() throws MailboxException {
            throw this.exception;
        }

        public int compareTo(MessageResult that) {
            long diff = this.uid - that.getUid();
            return (int)diff == 0 ? 0 : (diff > 0L ? 1 : -1);
        }

        public Content getFullContent(MessageResult.MimePath path) throws MailboxException {
            throw this.exception;
        }

        public Iterator<MessageResult.Header> iterateHeaders(MessageResult.MimePath path) throws MailboxException {
            throw this.exception;
        }

        public Iterator<MessageResult.Header> iterateMimeHeaders(MessageResult.MimePath path) throws MailboxException {
            throw this.exception;
        }

        public Content getBody(MessageResult.MimePath path) throws MailboxException {
            throw this.exception;
        }

        public Content getMimeBody(MessageResult.MimePath path) throws MailboxException {
            throw this.exception;
        }

        public MimeDescriptor getMimeDescriptor() throws MailboxException {
            throw this.exception;
        }

        public long getModSeq() {
            return this.modSeq;
        }
    }
}

