/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import org.apache.james.mailbox.MailboxMetaData;
import org.apache.james.mailbox.MailboxPath;
import org.apache.james.mailbox.StandardMailboxMetaDataComparator;

public class SimpleMailboxMetaData
implements MailboxMetaData,
Comparable<MailboxMetaData> {
    private final MailboxPath path;
    private final char delimiter;
    private final MailboxMetaData.Children inferiors;
    private final MailboxMetaData.Selectability selectability;

    public static MailboxMetaData createNoSelect(MailboxPath path, char delimiter) {
        return new SimpleMailboxMetaData(path, delimiter, MailboxMetaData.Children.CHILDREN_ALLOWED_BUT_UNKNOWN, MailboxMetaData.Selectability.NOSELECT);
    }

    public SimpleMailboxMetaData(MailboxPath path, char delimiter) {
        this(path, delimiter, MailboxMetaData.Children.CHILDREN_ALLOWED_BUT_UNKNOWN, MailboxMetaData.Selectability.NONE);
    }

    public SimpleMailboxMetaData(MailboxPath path, char delimiter, MailboxMetaData.Children inferiors, MailboxMetaData.Selectability selectability) {
        this.path = path;
        this.delimiter = delimiter;
        this.inferiors = inferiors;
        this.selectability = selectability;
    }

    public final MailboxMetaData.Children inferiors() {
        return this.inferiors;
    }

    public final MailboxMetaData.Selectability getSelectability() {
        return this.selectability;
    }

    public char getHierarchyDelimiter() {
        return this.delimiter;
    }

    public MailboxPath getPath() {
        return this.path;
    }

    public String toString() {
        return "ListResult: " + this.path;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleMailboxMetaData other = (SimpleMailboxMetaData)obj;
        return !(this.path == null ? other.path != null : !this.path.equals((Object)other.path));
    }

    @Override
    public int compareTo(MailboxMetaData o) {
        return StandardMailboxMetaDataComparator.order((MailboxMetaData)this, (MailboxMetaData)o);
    }
}

