/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import org.apache.james.mailbox.BadCredentialsException;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MailboxExistsException;
import org.apache.james.mailbox.MailboxListener;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxMetaData;
import org.apache.james.mailbox.MailboxNotFoundException;
import org.apache.james.mailbox.MailboxPath;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.MailboxQuery;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.MessageRange;
import org.apache.james.mailbox.RequestAware;
import org.apache.james.mailbox.StandardMailboxMetaDataComparator;
import org.apache.james.mailbox.store.AbstractDelegatingMailboxListener;
import org.apache.james.mailbox.store.Authenticator;
import org.apache.james.mailbox.store.HashMapDelegatingMailboxListener;
import org.apache.james.mailbox.store.JVMMailboxPathLocker;
import org.apache.james.mailbox.store.MailboxEventDispatcher;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.SimpleMailboxMetaData;
import org.apache.james.mailbox.store.SimpleMailboxSession;
import org.apache.james.mailbox.store.StoreMessageManager;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.impl.SimpleMailbox;
import org.apache.james.mailbox.store.search.ListeningMessageSearchIndex;
import org.apache.james.mailbox.store.search.MessageSearchIndex;
import org.apache.james.mailbox.store.search.SimpleMessageSearchIndex;
import org.apache.james.mailbox.store.transaction.Mapper;
import org.slf4j.Logger;

public class StoreMailboxManager<Id>
implements MailboxManager {
    public static final char SQL_WILDCARD_CHAR = '%';
    private final MailboxEventDispatcher<Id> dispatcher = new MailboxEventDispatcher();
    private AbstractDelegatingMailboxListener delegatingListener = null;
    private final MailboxSessionMapperFactory<Id> mailboxSessionMapperFactory;
    private final Authenticator authenticator;
    private static final Random RANDOM = new Random();
    private MailboxPathLocker locker;
    private MessageSearchIndex<Id> index;

    public StoreMailboxManager(MailboxSessionMapperFactory<Id> mailboxSessionMapperFactory, Authenticator authenticator, MailboxPathLocker locker) {
        this.authenticator = authenticator;
        this.locker = locker;
        this.mailboxSessionMapperFactory = mailboxSessionMapperFactory;
    }

    public StoreMailboxManager(MailboxSessionMapperFactory<Id> mailboxSessionMapperFactory, Authenticator authenticator) {
        this(mailboxSessionMapperFactory, authenticator, new JVMMailboxPathLocker());
    }

    public void init() throws MailboxException {
        this.dispatcher.addMailboxListener(this.getDelegationListener());
        if (this.index == null) {
            this.index = new SimpleMessageSearchIndex<Id>(this.mailboxSessionMapperFactory);
        }
        if (this.index instanceof ListeningMessageSearchIndex) {
            this.addGlobalListener((ListeningMessageSearchIndex)this.index, null);
        }
    }

    public AbstractDelegatingMailboxListener getDelegationListener() {
        if (this.delegatingListener == null) {
            this.delegatingListener = new HashMapDelegatingMailboxListener();
        }
        return this.delegatingListener;
    }

    public MessageSearchIndex<Id> getMessageSearchIndex() {
        return this.index;
    }

    public MailboxEventDispatcher<Id> getEventDispatcher() {
        return this.dispatcher;
    }

    public MailboxSessionMapperFactory<Id> getMapperFactory() {
        return this.mailboxSessionMapperFactory;
    }

    public void setDelegatingMailboxListener(AbstractDelegatingMailboxListener delegatingListener) {
        if (this.delegatingListener != null) {
            this.delegatingListener.close();
        }
        this.delegatingListener = delegatingListener;
        this.dispatcher.addMailboxListener(this.delegatingListener);
    }

    public void setMessageSearchIndex(MessageSearchIndex<Id> index) {
        this.index = index;
    }

    protected int randomUidValidity() {
        return Math.abs(RANDOM.nextInt());
    }

    public MailboxSession createSystemSession(String userName, Logger log) {
        return this.createSession(userName, null, log, MailboxSession.SessionType.System);
    }

    private MailboxSession createSession(String userName, String password, Logger log, MailboxSession.SessionType type) {
        return new SimpleMailboxSession(this.randomId(), userName, password, log, new ArrayList<Locale>(), this.getDelimiter(), type);
    }

    protected long randomId() {
        return RANDOM.nextLong();
    }

    public char getDelimiter() {
        return '.';
    }

    private boolean login(String userid, String passwd) {
        return this.authenticator.isAuthentic(userid, passwd);
    }

    public MailboxSession login(String userid, String passwd, Logger log) throws BadCredentialsException, MailboxException {
        if (this.login(userid, passwd)) {
            return this.createSession(userid, passwd, log, MailboxSession.SessionType.User);
        }
        throw new BadCredentialsException();
    }

    public void logout(MailboxSession session, boolean force) throws MailboxException {
        if (session != null) {
            session.close();
        }
    }

    protected StoreMessageManager<Id> createMessageManager(Mailbox<Id> mailbox, MailboxSession session) throws MailboxException {
        return new StoreMessageManager<Id>(this.getMapperFactory(), this.getMessageSearchIndex(), this.getEventDispatcher(), mailbox);
    }

    protected Mailbox<Id> doCreateMailbox(MailboxPath mailboxPath, MailboxSession session) throws MailboxException {
        return new SimpleMailbox(mailboxPath, this.randomUidValidity());
    }

    public MessageManager getMailbox(MailboxPath mailboxPath, MailboxSession session) throws MailboxException {
        MailboxMapper<Id> mapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        Mailbox<Id> mailboxRow = mapper.findMailboxByPath(mailboxPath);
        if (mailboxRow == null) {
            session.getLog().info("Mailbox '" + mailboxPath + "' not found.");
            throw new MailboxNotFoundException(mailboxPath);
        }
        session.getLog().debug("Loaded mailbox " + mailboxPath);
        StoreMessageManager<Id> m = this.createMessageManager(mailboxRow, session);
        return m;
    }

    public void createMailbox(MailboxPath mailboxPath, final MailboxSession mailboxSession) throws MailboxException {
        mailboxSession.getLog().debug("createMailbox " + mailboxPath);
        int length = mailboxPath.getName().length();
        if (length == 0) {
            mailboxSession.getLog().warn("Ignoring mailbox with empty name");
        } else {
            if (mailboxPath.getName().charAt(length - 1) == this.getDelimiter()) {
                mailboxPath.setName(mailboxPath.getName().substring(0, length - 1));
            }
            if (this.mailboxExists(mailboxPath, mailboxSession)) {
                throw new MailboxExistsException(mailboxPath.toString());
            }
            for (final MailboxPath mailbox : mailboxPath.getHierarchyLevels(this.getDelimiter())) {
                this.locker.executeWithLock(mailboxSession, mailbox, (MailboxPathLocker.LockAwareExecution)new MailboxPathLocker.LockAwareExecution<Void>(){

                    public Void execute() throws MailboxException {
                        if (!StoreMailboxManager.this.mailboxExists(mailbox, mailboxSession)) {
                            final Mailbox m = StoreMailboxManager.this.doCreateMailbox(mailbox, mailboxSession);
                            final MailboxMapper mapper = StoreMailboxManager.this.mailboxSessionMapperFactory.getMailboxMapper(mailboxSession);
                            mapper.execute(new Mapper.VoidTransaction(){

                                @Override
                                public void runVoid() throws MailboxException {
                                    mapper.save(m);
                                }
                            });
                            StoreMailboxManager.this.dispatcher.mailboxAdded(mailboxSession, m);
                        }
                        return null;
                    }
                });
            }
        }
    }

    public void deleteMailbox(final MailboxPath mailboxPath, MailboxSession session) throws MailboxException {
        session.getLog().info("deleteMailbox " + mailboxPath);
        final MailboxMapper<Id> mapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        Mailbox mailbox = (Mailbox)mapper.execute(new Mapper.Transaction<Mailbox<Id>>(){

            @Override
            public Mailbox<Id> run() throws MailboxException {
                Mailbox mailbox = mapper.findMailboxByPath(mailboxPath);
                if (mailbox == null) {
                    throw new MailboxNotFoundException("Mailbox not found");
                }
                SimpleMailbox m = new SimpleMailbox(mailbox);
                mapper.delete(mailbox);
                return m;
            }
        });
        this.dispatcher.mailboxDeleted(session, mailbox);
    }

    public void renameMailbox(final MailboxPath from, final MailboxPath to, final MailboxSession session) throws MailboxException {
        final Logger log = session.getLog();
        if (log.isDebugEnabled()) {
            log.debug("renameMailbox " + from + " to " + to);
        }
        if (this.mailboxExists(to, session)) {
            throw new MailboxExistsException(to.toString());
        }
        final MailboxMapper<Id> mapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        mapper.execute(new Mapper.VoidTransaction(){

            @Override
            public void runVoid() throws MailboxException {
                Mailbox mailbox = mapper.findMailboxByPath(from);
                if (mailbox == null) {
                    throw new MailboxNotFoundException(from);
                }
                mailbox.setNamespace(to.getNamespace());
                mailbox.setUser(to.getUser());
                mailbox.setName(to.getName());
                mapper.save(mailbox);
                StoreMailboxManager.this.dispatcher.mailboxRenamed(session, from, mailbox);
                final MailboxPath children = new MailboxPath("#private", from.getUser(), from.getName() + StoreMailboxManager.this.getDelimiter() + "%");
                StoreMailboxManager.this.locker.executeWithLock(session, children, (MailboxPathLocker.LockAwareExecution)new MailboxPathLocker.LockAwareExecution<Void>(){

                    public Void execute() throws MailboxException {
                        List subMailboxes = mapper.findMailboxWithPathLike(children);
                        for (Mailbox sub : subMailboxes) {
                            String subOriginalName = sub.getName();
                            String subNewName = to.getName() + subOriginalName.substring(from.getName().length());
                            MailboxPath fromPath = new MailboxPath(children, subOriginalName);
                            sub.setName(subNewName);
                            mapper.save(sub);
                            StoreMailboxManager.this.dispatcher.mailboxRenamed(session, fromPath, sub);
                            if (!log.isDebugEnabled()) continue;
                            log.debug("Rename mailbox sub-mailbox " + subOriginalName + " to " + subNewName);
                        }
                        return null;
                    }
                });
            }
        });
    }

    public List<MessageRange> copyMessages(MessageRange set, MailboxPath from, MailboxPath to, MailboxSession session) throws MailboxException {
        StoreMessageManager toMailbox = (StoreMessageManager)this.getMailbox(to, session);
        StoreMessageManager fromMailbox = (StoreMessageManager)this.getMailbox(from, session);
        return fromMailbox.copyTo(set, toMailbox, session);
    }

    public List<MailboxMetaData> search(MailboxQuery mailboxExpression, MailboxSession session) throws MailboxException {
        char localWildcard = mailboxExpression.getLocalWildcard();
        char freeWildcard = mailboxExpression.getFreeWildcard();
        String baseName = mailboxExpression.getBase().getName();
        int baseLength = baseName == null ? 0 : baseName.length();
        String combinedName = mailboxExpression.getCombinedName().replace(freeWildcard, '%').replace(localWildcard, '%');
        MailboxPath search = new MailboxPath(mailboxExpression.getBase(), combinedName);
        MailboxMapper<Id> mapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        List<Mailbox<Id>> mailboxes = mapper.findMailboxWithPathLike(search);
        ArrayList<MailboxMetaData> results = new ArrayList<MailboxMetaData>(mailboxes.size());
        for (Mailbox<Id> mailbox : mailboxes) {
            String match;
            String name = mailbox.getName();
            if (!name.startsWith(baseName) || !mailboxExpression.isExpressionMatch(match = name.substring(baseLength))) continue;
            MailboxMetaData.Children inferiors = mapper.hasChildren(mailbox, session.getPathDelimiter()) ? MailboxMetaData.Children.HAS_CHILDREN : MailboxMetaData.Children.HAS_NO_CHILDREN;
            MailboxPath mailboxPath = new MailboxPath(mailbox.getNamespace(), mailbox.getUser(), name);
            results.add(new SimpleMailboxMetaData(mailboxPath, this.getDelimiter(), inferiors, MailboxMetaData.Selectability.NONE));
        }
        Collections.sort(results, new StandardMailboxMetaDataComparator());
        return results;
    }

    public boolean mailboxExists(MailboxPath mailboxPath, MailboxSession session) throws MailboxException {
        try {
            MailboxMapper<Id> mapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
            mapper.findMailboxByPath(mailboxPath);
            return true;
        }
        catch (MailboxNotFoundException e) {
            return false;
        }
    }

    public void addListener(MailboxPath path, MailboxListener listener, MailboxSession session) throws MailboxException {
        this.delegatingListener.addListener(path, listener, session);
    }

    public void endProcessingRequest(MailboxSession session) {
        if (this.mailboxSessionMapperFactory instanceof RequestAware) {
            this.mailboxSessionMapperFactory.endProcessingRequest(session);
        }
    }

    public void startProcessingRequest(MailboxSession session) {
    }

    public List<MailboxPath> list(MailboxSession session) throws MailboxException {
        ArrayList<MailboxPath> mList = new ArrayList<MailboxPath>();
        List<Mailbox<Id>> mailboxes = this.mailboxSessionMapperFactory.getMailboxMapper(session).list();
        for (int i = 0; i < mailboxes.size(); ++i) {
            Mailbox<Id> m = mailboxes.get(i);
            mList.add(new MailboxPath(m.getNamespace(), m.getUser(), m.getName()));
        }
        return Collections.unmodifiableList(mList);
    }

    public void addGlobalListener(MailboxListener listener, MailboxSession session) throws MailboxException {
        this.delegatingListener.addGlobalListener(listener, session);
    }
}

