/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.mail.Flags;
import javax.mail.internet.SharedInputStream;
import javax.mail.util.SharedFileInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.TeeInputStream;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MailboxListener;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.MessageMetaData;
import org.apache.james.mailbox.MessageRange;
import org.apache.james.mailbox.MessageResult;
import org.apache.james.mailbox.SearchQuery;
import org.apache.james.mailbox.UpdatedFlags;
import org.apache.james.mailbox.store.MailboxEventDispatcher;
import org.apache.james.mailbox.store.MailboxMetaData;
import org.apache.james.mailbox.store.ResultIterator;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.MessageMapperFactory;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.Message;
import org.apache.james.mailbox.store.mail.model.impl.PropertyBuilder;
import org.apache.james.mailbox.store.mail.model.impl.SimpleMessage;
import org.apache.james.mailbox.store.search.MessageSearchIndex;
import org.apache.james.mailbox.store.streaming.BodyOffsetInputStream;
import org.apache.james.mailbox.store.streaming.ConfigurableMimeTokenStream;
import org.apache.james.mailbox.store.streaming.CountingInputStream;
import org.apache.james.mailbox.store.transaction.Mapper;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.descriptor.MaximalBodyDescriptor;
import org.apache.james.mime4j.message.Header;
import org.apache.james.mime4j.parser.MimeEntityConfig;

public class StoreMessageManager<Id>
implements MessageManager {
    protected static final Flags MINIMAL_PERMANET_FLAGS = new Flags();
    private final Mailbox<Id> mailbox;
    private final MailboxEventDispatcher<Id> dispatcher;
    private final MessageMapperFactory<Id> mapperFactory;
    private final MessageSearchIndex<Id> index;

    public StoreMessageManager(MessageMapperFactory<Id> mapperFactory, MessageSearchIndex<Id> index, MailboxEventDispatcher<Id> dispatcher, Mailbox<Id> mailbox) throws MailboxException {
        this.mailbox = mailbox;
        this.dispatcher = dispatcher;
        this.mapperFactory = mapperFactory;
        this.index = index;
    }

    protected MailboxEventDispatcher<Id> getDispatcher() {
        return this.dispatcher;
    }

    public Mailbox<Id> getMailboxEntity() throws MailboxException {
        return this.mailbox;
    }

    protected Flags getPermanentFlags(MailboxSession session) {
        return MINIMAL_PERMANET_FLAGS;
    }

    public boolean isModSeqPermanent(MailboxSession session) {
        return true;
    }

    public Iterator<Long> expunge(MessageRange set, MailboxSession mailboxSession) throws MailboxException {
        Map<Long, MessageMetaData> uids = this.deleteMarkedInMailbox(set, mailboxSession);
        this.dispatcher.expunged(mailboxSession, uids, this.getMailboxEntity());
        return uids.keySet().iterator();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long appendMessage(InputStream msgIn, Date internalDate, MailboxSession mailboxSession, boolean isRecent, Flags flagsToBeSet) throws MailboxException {
        long l;
        File file = null;
        TeeInputStream tmpMsgIn = null;
        BodyOffsetInputStream bIn = null;
        FileOutputStream out = null;
        SharedFileInputStream contentIn = null;
        try {
            Flags flags;
            String boundary;
            String subType;
            String mediaType;
            file = File.createTempFile("imap", ".msg");
            out = new FileOutputStream(file);
            tmpMsgIn = new TeeInputStream(msgIn, (OutputStream)out);
            bIn = new BodyOffsetInputStream((InputStream)tmpMsgIn);
            MimeEntityConfig config = new MimeEntityConfig();
            config.setMaximalBodyDescriptor(true);
            config.setMaxLineLen(-1);
            ConfigurableMimeTokenStream parser = new ConfigurableMimeTokenStream(config);
            parser.setRecursionMode(1);
            parser.parse(bIn);
            Header header = new Header();
            int next = parser.next();
            while (next != 12 && next != -1 && next != 6) {
                if (next == 4) {
                    header.addField(parser.getField());
                }
                next = parser.next();
            }
            MaximalBodyDescriptor descriptor = (MaximalBodyDescriptor)parser.getBodyDescriptor();
            PropertyBuilder propertyBuilder = new PropertyBuilder();
            String mediaTypeFromHeader = descriptor.getMediaType();
            if (mediaTypeFromHeader == null) {
                mediaType = "text";
                subType = "plain";
            } else {
                mediaType = mediaTypeFromHeader;
                subType = descriptor.getSubType();
            }
            propertyBuilder.setMediaType(mediaType);
            propertyBuilder.setSubType(subType);
            propertyBuilder.setContentID(descriptor.getContentId());
            propertyBuilder.setContentDescription(descriptor.getContentDescription());
            propertyBuilder.setContentLocation(descriptor.getContentLocation());
            propertyBuilder.setContentMD5(descriptor.getContentMD5Raw());
            propertyBuilder.setContentTransferEncoding(descriptor.getTransferEncoding());
            propertyBuilder.setContentLanguage(descriptor.getContentLanguage());
            propertyBuilder.setContentDispositionType(descriptor.getContentDispositionType());
            propertyBuilder.setContentDispositionParameters(descriptor.getContentDispositionParameters());
            propertyBuilder.setContentTypeParameters(descriptor.getContentTypeParameters());
            String codeset = descriptor.getCharset();
            if (codeset == null) {
                if ("TEXT".equalsIgnoreCase(mediaType)) {
                    propertyBuilder.setCharset("us-ascii");
                }
            } else {
                propertyBuilder.setCharset(codeset);
            }
            if ((boundary = descriptor.getBoundary()) != null) {
                propertyBuilder.setBoundary(boundary);
            }
            if ("text".equalsIgnoreCase(mediaType)) {
                CountingInputStream bodyStream = new CountingInputStream(parser.getInputStream());
                bodyStream.readAll();
                long lines = bodyStream.getLineCount();
                bodyStream.close();
                next = parser.next();
                if (next == 9) {
                    CountingInputStream epilogueStream = new CountingInputStream(parser.getInputStream());
                    epilogueStream.readAll();
                    lines += (long)epilogueStream.getLineCount();
                    epilogueStream.close();
                }
                propertyBuilder.setTextualLineCount(lines);
            }
            if (flagsToBeSet == null) {
                flags = new Flags();
            } else {
                flags = flagsToBeSet;
                this.trimFlags(flags, mailboxSession);
            }
            if (isRecent) {
                flags.add(Flags.Flag.RECENT);
            }
            if (internalDate == null) {
                internalDate = new Date();
            }
            byte[] discard = new byte[4096];
            while (tmpMsgIn.read(discard) != -1) {
            }
            int bodyStartOctet = (int)bIn.getBodyStartOffset();
            if (bodyStartOctet == -1) {
                bodyStartOctet = 0;
            }
            contentIn = new SharedFileInputStream(file);
            int size = (int)file.length();
            Message<Id> message = this.createMessage(internalDate, size, bodyStartOctet, (SharedInputStream)contentIn, flags, propertyBuilder);
            MessageMetaData data = this.appendMessageToStore(message, mailboxSession);
            HashMap<Long, MessageMetaData> uids = new HashMap<Long, MessageMetaData>();
            uids.put(data.getUid(), data);
            this.dispatcher.added(mailboxSession, uids, this.getMailboxEntity());
            l = data.getUid();
        }
        catch (IOException e) {
            try {
                throw new MailboxException("Unable to parse message", (Exception)e);
                catch (MimeException e2) {
                    throw new MailboxException("Unable to parse message", (Exception)((Object)e2));
                }
                catch (MailboxException e3) {
                    throw new MailboxException("Unable to parse message", (Exception)((Object)e3));
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bIn);
                IOUtils.closeQuietly(tmpMsgIn);
                IOUtils.closeQuietly(out);
                IOUtils.closeQuietly(contentIn);
                if (file != null) {
                    file.delete();
                }
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)bIn);
        IOUtils.closeQuietly((InputStream)tmpMsgIn);
        IOUtils.closeQuietly((OutputStream)out);
        IOUtils.closeQuietly((InputStream)contentIn);
        if (file != null) {
            file.delete();
        }
        return l;
    }

    protected Message<Id> createMessage(Date internalDate, int size, int bodyStartOctet, SharedInputStream content, Flags flags, PropertyBuilder propertyBuilder) throws MailboxException {
        return new SimpleMessage<Id>(internalDate, size, bodyStartOctet, content, flags, propertyBuilder, this.getMailboxEntity().getMailboxId());
    }

    public void addListener(MailboxListener listener) throws MailboxException {
        this.dispatcher.addMailboxListener(listener);
    }

    public boolean isWriteable(MailboxSession session) {
        return true;
    }

    public MessageManager.MetaData getMetaData(boolean resetRecent, MailboxSession mailboxSession, MessageManager.MetaData.FetchGroup fetchGroup) throws MailboxException {
        Long firstUnseen;
        long messageCount;
        long unseenCount;
        List<Long> recent = this.recent(resetRecent, mailboxSession);
        Flags permanentFlags = this.getPermanentFlags(mailboxSession);
        long uidValidity = this.getMailboxEntity().getUidValidity();
        long uidNext = this.mapperFactory.getMessageMapper(mailboxSession).getLastUid(this.mailbox) + 1L;
        long highestModSeq = this.mapperFactory.getMessageMapper(mailboxSession).getHighestModSeq(this.mailbox);
        switch (fetchGroup) {
            case UNSEEN_COUNT: {
                unseenCount = this.countUnseenMessagesInMailbox(mailboxSession);
                messageCount = this.getMessageCount(mailboxSession);
                firstUnseen = null;
                break;
            }
            case FIRST_UNSEEN: {
                firstUnseen = this.findFirstUnseenMessageUid(mailboxSession);
                messageCount = this.getMessageCount(mailboxSession);
                unseenCount = 0L;
                break;
            }
            case NO_UNSEEN: {
                firstUnseen = null;
                unseenCount = 0L;
                messageCount = this.getMessageCount(mailboxSession);
                break;
            }
            default: {
                firstUnseen = null;
                unseenCount = 0L;
                messageCount = -1L;
            }
        }
        return new MailboxMetaData(recent, permanentFlags, uidValidity, uidNext, highestModSeq, messageCount, unseenCount, firstUnseen, this.isWriteable(mailboxSession), this.isModSeqPermanent(mailboxSession));
    }

    private void trimFlags(Flags flags, MailboxSession session) {
        Flags permFlags = this.getPermanentFlags(session);
        Flags.Flag[] systemFlags = flags.getSystemFlags();
        for (int i = 0; i < systemFlags.length; ++i) {
            Flags.Flag f = systemFlags[i];
            if (f == Flags.Flag.RECENT || permFlags.contains(f)) continue;
            flags.remove(f);
        }
        if (!permFlags.contains(Flags.Flag.USER)) {
            String[] uFlags = flags.getUserFlags();
            for (int i = 0; i < uFlags.length; ++i) {
                String uFlag = uFlags[i];
                if (permFlags.contains(uFlag)) continue;
                flags.remove(uFlag);
            }
        }
    }

    public Map<Long, Flags> setFlags(final Flags flags, final boolean value, final boolean replace, final MessageRange set, MailboxSession mailboxSession) throws MailboxException {
        TreeMap<Long, Flags> newFlagsByUid = new TreeMap<Long, Flags>();
        this.trimFlags(flags, mailboxSession);
        final MessageMapper<Id> messageMapper = this.mapperFactory.getMessageMapper(mailboxSession);
        Iterator<UpdatedFlags> it = messageMapper.execute(new Mapper.Transaction<Iterator<UpdatedFlags>>(){

            @Override
            public Iterator<UpdatedFlags> run() throws MailboxException {
                return messageMapper.updateFlags(StoreMessageManager.this.getMailboxEntity(), flags, value, replace, set);
            }
        });
        TreeMap<Long, UpdatedFlags> uFlags = new TreeMap<Long, UpdatedFlags>();
        while (it.hasNext()) {
            UpdatedFlags flag = it.next();
            newFlagsByUid.put(flag.getUid(), flag.getNewFlags());
            uFlags.put(flag.getUid(), flag);
        }
        this.dispatcher.flagsUpdated(mailboxSession, new ArrayList<Long>(uFlags.keySet()), this.getMailboxEntity(), new ArrayList<UpdatedFlags>(uFlags.values()));
        return newFlagsByUid;
    }

    public List<MessageRange> copyTo(MessageRange set, StoreMessageManager<Id> toMailbox, MailboxSession session) throws MailboxException {
        try {
            Map<Long, MessageMetaData> copiedUids = this.copy(set, toMailbox, session);
            this.dispatcher.added(session, copiedUids, toMailbox.getMailboxEntity());
            return MessageRange.toRanges(new ArrayList<Long>(copiedUids.keySet()));
        }
        catch (MailboxException e) {
            throw new MailboxException("Unable to parse message", (Exception)((Object)e));
        }
    }

    protected MessageMetaData appendMessageToStore(final Message<Id> message, MailboxSession session) throws MailboxException {
        final MessageMapper<Id> mapper = this.mapperFactory.getMessageMapper(session);
        return this.mapperFactory.getMessageMapper(session).execute(new Mapper.Transaction<MessageMetaData>(){

            @Override
            public MessageMetaData run() throws MailboxException {
                return mapper.add(StoreMessageManager.this.getMailboxEntity(), message);
            }
        });
    }

    public long getMessageCount(MailboxSession mailboxSession) throws MailboxException {
        return this.mapperFactory.getMessageMapper(mailboxSession).countMessagesInMailbox(this.getMailboxEntity());
    }

    public Iterator<MessageResult> getMessages(MessageRange set, MessageResult.FetchGroup fetchGroup, MailboxSession mailboxSession) throws MailboxException {
        MessageRange nonBatchedSet = set.getUnlimitedRange();
        class InterceptingCallback
        implements MessageManager.MessageCallback {
            Iterator<MessageResult> iterator;

            InterceptingCallback() {
            }

            public void onMessages(Iterator<MessageResult> it) throws MailboxException {
                this.iterator = it;
            }

            public Iterator<MessageResult> getIterator() {
                if (this.iterator == null) {
                    this.iterator = new ResultIterator(null, null);
                }
                return this.iterator;
            }
        }
        InterceptingCallback callback = new InterceptingCallback();
        this.getMessages(nonBatchedSet, fetchGroup, mailboxSession, callback);
        return callback.getIterator();
    }

    public void getMessages(MessageRange set, final MessageResult.FetchGroup fetchGroup, MailboxSession mailboxSession, final MessageManager.MessageCallback messageCallback) throws MailboxException {
        this.mapperFactory.getMessageMapper(mailboxSession).findInMailbox(this.getMailboxEntity(), set, StoreMessageManager.getFetchType(fetchGroup), new MessageMapper.MessageCallback<Id>(){

            @Override
            public void onMessages(List<Message<Id>> rows) throws MailboxException {
                messageCallback.onMessages(new ResultIterator(rows.iterator(), fetchGroup));
            }
        });
    }

    protected static final MessageMapper.FetchType getFetchType(MessageResult.FetchGroup group) {
        int content = group.content();
        boolean headers = false;
        boolean body = false;
        boolean full = false;
        if ((content & 0x100) > 0) {
            headers = true;
            content -= 256;
        }
        if ((content & 0x400) > 0) {
            body = true;
            content -= 1024;
        }
        if ((content & 0x200) > 0) {
            full = true;
            content -= 512;
        }
        if ((content & 1) > 0) {
            full = true;
            --content;
        }
        if (full || body && headers) {
            return MessageMapper.FetchType.Full;
        }
        if (body) {
            return MessageMapper.FetchType.Body;
        }
        if (headers) {
            return MessageMapper.FetchType.Headers;
        }
        return MessageMapper.FetchType.Metadata;
    }

    protected List<Long> recent(final boolean reset, MailboxSession mailboxSession) throws MailboxException {
        final MessageMapper<Id> messageMapper = this.mapperFactory.getMessageMapper(mailboxSession);
        return messageMapper.execute(new Mapper.Transaction<List<Long>>(){

            @Override
            public List<Long> run() throws MailboxException {
                List<Long> members = messageMapper.findRecentMessageUidsInMailbox(StoreMessageManager.this.getMailboxEntity());
                List ranges = MessageRange.toRanges(members);
                for (MessageRange range : ranges) {
                    if (!reset) continue;
                    messageMapper.updateFlags(StoreMessageManager.this.getMailboxEntity(), new Flags(Flags.Flag.RECENT), false, false, range);
                }
                return members;
            }
        });
    }

    protected Map<Long, MessageMetaData> deleteMarkedInMailbox(final MessageRange range, MailboxSession session) throws MailboxException {
        final MessageMapper<Id> messageMapper = this.mapperFactory.getMessageMapper(session);
        return messageMapper.execute(new Mapper.Transaction<Map<Long, MessageMetaData>>(){

            @Override
            public Map<Long, MessageMetaData> run() throws MailboxException {
                return messageMapper.expungeMarkedForDeletionInMailbox(StoreMessageManager.this.getMailboxEntity(), range);
            }
        });
    }

    public Iterator<Long> search(SearchQuery query, MailboxSession mailboxSession) throws MailboxException {
        return this.index.search(mailboxSession, this.getMailboxEntity(), query);
    }

    private Iterator<MessageMetaData> copy(List<Message<Id>> originalRows, MailboxSession session) throws MailboxException {
        try {
            ArrayList<MessageMetaData> copiedRows = new ArrayList<MessageMetaData>();
            final MessageMapper<Id> messageMapper = this.mapperFactory.getMessageMapper(session);
            for (final Message<Id> originalMessage : originalRows) {
                MessageMetaData data = messageMapper.execute(new Mapper.Transaction<MessageMetaData>(){

                    @Override
                    public MessageMetaData run() throws MailboxException {
                        return messageMapper.copy(StoreMessageManager.this.getMailboxEntity(), originalMessage);
                    }
                });
                copiedRows.add(data);
            }
            return copiedRows.iterator();
        }
        catch (MailboxException e) {
            throw new MailboxException("Unable to parse message", (Exception)((Object)e));
        }
    }

    private Map<Long, MessageMetaData> copy(MessageRange set, final StoreMessageManager<Id> to, final MailboxSession session) throws MailboxException {
        try {
            MessageMapper<Id> messageMapper = this.mapperFactory.getMessageMapper(session);
            final HashMap<Long, MessageMetaData> copiedMessages = new HashMap<Long, MessageMetaData>();
            messageMapper.findInMailbox(this.getMailboxEntity(), set, MessageMapper.FetchType.Full, new MessageMapper.MessageCallback<Id>(){

                @Override
                public void onMessages(List<Message<Id>> originalRows) throws MailboxException {
                    Iterator ids = to.copy(originalRows, session);
                    while (ids.hasNext()) {
                        MessageMetaData data = (MessageMetaData)ids.next();
                        copiedMessages.put(data.getUid(), data);
                    }
                }
            });
            return copiedMessages;
        }
        catch (MailboxException e) {
            throw new MailboxException("Unable to parse message", (Exception)((Object)e));
        }
    }

    protected long countUnseenMessagesInMailbox(MailboxSession session) throws MailboxException {
        MessageMapper<Id> messageMapper = this.mapperFactory.getMessageMapper(session);
        return messageMapper.countUnseenMessagesInMailbox(this.getMailboxEntity());
    }

    protected Long findFirstUnseenMessageUid(MailboxSession session) throws MailboxException {
        MessageMapper<Id> messageMapper = this.mapperFactory.getMessageMapper(session);
        return messageMapper.findFirstUnseenMessageUid(this.getMailboxEntity());
    }

    static {
        MINIMAL_PERMANET_FLAGS.add(Flags.Flag.ANSWERED);
        MINIMAL_PERMANET_FLAGS.add(Flags.Flag.DELETED);
        MINIMAL_PERMANET_FLAGS.add(Flags.Flag.DRAFT);
        MINIMAL_PERMANET_FLAGS.add(Flags.Flag.FLAGGED);
        MINIMAL_PERMANET_FLAGS.add(Flags.Flag.SEEN);
    }
}

