/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.mail;

import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.store.StoreMailboxPath;
import org.apache.james.mailbox.store.mail.ModSeqProvider;
import org.apache.james.mailbox.store.mail.model.Mailbox;

public abstract class AbstractLockingModSeqProvider<Id>
implements ModSeqProvider<Id> {
    private final MailboxPathLocker locker;

    public AbstractLockingModSeqProvider(MailboxPathLocker locker) {
        this.locker = locker;
    }

    @Override
    public long nextModSeq(final MailboxSession session, final Mailbox<Id> mailbox) throws MailboxException {
        return (Long)this.locker.executeWithLock(session, new StoreMailboxPath<Id>(mailbox), (MailboxPathLocker.LockAwareExecution)new MailboxPathLocker.LockAwareExecution<Long>(){

            public Long execute() throws MailboxException {
                return AbstractLockingModSeqProvider.this.lockedNextModSeq(session, mailbox);
            }
        });
    }

    protected abstract long lockedNextModSeq(MailboxSession var1, Mailbox<Id> var2) throws MailboxException;
}

