/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.mail;

import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.store.StoreMailboxPath;
import org.apache.james.mailbox.store.mail.UidProvider;
import org.apache.james.mailbox.store.mail.model.Mailbox;

public abstract class AbstractLockingUidProvider<Id>
implements UidProvider<Id> {
    private final MailboxPathLocker locker;

    public AbstractLockingUidProvider(MailboxPathLocker locker) {
        this.locker = locker;
    }

    @Override
    public long nextUid(final MailboxSession session, final Mailbox<Id> mailbox) throws MailboxException {
        return (Long)this.locker.executeWithLock(session, new StoreMailboxPath<Id>(mailbox), (MailboxPathLocker.LockAwareExecution)new MailboxPathLocker.LockAwareExecution<Long>(){

            public Long execute() throws MailboxException {
                return AbstractLockingUidProvider.this.lockedNextUid(session, mailbox);
            }
        });
    }

    protected abstract long lockedNextUid(MailboxSession var1, Mailbox<Id> var2) throws MailboxException;
}

