/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.mail;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.mail.Flags;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageMetaData;
import org.apache.james.mailbox.MessageRange;
import org.apache.james.mailbox.UpdatedFlags;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.ModSeqProvider;
import org.apache.james.mailbox.store.mail.UidProvider;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.Message;
import org.apache.james.mailbox.store.transaction.TransactionalMapper;

public abstract class AbstractMessageMapper<Id>
extends TransactionalMapper
implements MessageMapper<Id> {
    protected final MailboxSession mailboxSession;
    private final UidProvider<Id> uidProvider;
    private final ModSeqProvider<Id> modSeqProvider;

    public AbstractMessageMapper(MailboxSession mailboxSession, UidProvider<Id> uidProvider, ModSeqProvider<Id> modSeqProvider) {
        this.mailboxSession = mailboxSession;
        this.uidProvider = uidProvider;
        this.modSeqProvider = modSeqProvider;
    }

    @Override
    public long getHighestModSeq(Mailbox<Id> mailbox) throws MailboxException {
        return this.modSeqProvider.highestModSeq(this.mailboxSession, mailbox);
    }

    @Override
    public long getLastUid(Mailbox<Id> mailbox) throws MailboxException {
        return this.uidProvider.lastUid(this.mailboxSession, mailbox);
    }

    @Override
    public Iterator<UpdatedFlags> updateFlags(final Mailbox<Id> mailbox, final Flags flags, final boolean value, final boolean replace, MessageRange set) throws MailboxException {
        final ArrayList updatedFlags = new ArrayList();
        this.findInMailbox(mailbox, set, MessageMapper.FetchType.Metadata, new MessageMapper.MessageCallback<Id>(){

            @Override
            public void onMessages(List<Message<Id>> members) throws MailboxException {
                long modSeq = -1L;
                if (!members.isEmpty() && AbstractMessageMapper.this.modSeqProvider != null) {
                    modSeq = AbstractMessageMapper.this.modSeqProvider.nextModSeq(AbstractMessageMapper.this.mailboxSession, mailbox);
                }
                for (Message member : members) {
                    Flags originalFlags = member.createFlags();
                    if (replace) {
                        member.setFlags(flags);
                    } else {
                        Flags current = member.createFlags();
                        if (value) {
                            current.add(flags);
                        } else {
                            current.remove(flags);
                        }
                        member.setFlags(current);
                    }
                    Flags newFlags = member.createFlags();
                    if (UpdatedFlags.flagsChanged((Flags)originalFlags, (Flags)newFlags)) {
                        member.setModSeq(modSeq);
                        AbstractMessageMapper.this.save(mailbox, member);
                    }
                    UpdatedFlags uFlags = new UpdatedFlags(member.getUid(), member.getModSeq(), originalFlags, newFlags);
                    updatedFlags.add(uFlags);
                }
            }
        });
        return updatedFlags.iterator();
    }

    @Override
    public MessageMetaData add(Mailbox<Id> mailbox, Message<Id> message) throws MailboxException {
        message.setUid(this.uidProvider.nextUid(this.mailboxSession, mailbox));
        if (this.modSeqProvider != null) {
            message.setModSeq(this.modSeqProvider.nextModSeq(this.mailboxSession, mailbox));
        }
        MessageMetaData data = this.save(mailbox, message);
        return data;
    }

    @Override
    public MessageMetaData copy(Mailbox<Id> mailbox, Message<Id> original) throws MailboxException {
        long uid = this.uidProvider.nextUid(this.mailboxSession, mailbox);
        long modSeq = -1L;
        if (this.modSeqProvider != null) {
            modSeq = this.modSeqProvider.nextModSeq(this.mailboxSession, mailbox);
        }
        MessageMetaData metaData = this.copy(mailbox, uid, modSeq, original);
        return metaData;
    }

    protected abstract MessageMetaData save(Mailbox<Id> var1, Message<Id> var2) throws MailboxException;

    protected abstract MessageMetaData copy(Mailbox<Id> var1, long var2, long var4, Message<Id> var6) throws MailboxException;
}

