/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.mail;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.mail.Flags;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MessageMetaData;
import org.apache.james.mailbox.MessageRange;
import org.apache.james.mailbox.UpdatedFlags;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.Message;
import org.apache.james.mailbox.store.transaction.Mapper;

public interface MessageMapper<Id>
extends Mapper {
    public void findInMailbox(Mailbox<Id> var1, MessageRange var2, FetchType var3, MessageCallback<Id> var4) throws MailboxException;

    public Map<Long, MessageMetaData> expungeMarkedForDeletionInMailbox(Mailbox<Id> var1, MessageRange var2) throws MailboxException;

    public long countMessagesInMailbox(Mailbox<Id> var1) throws MailboxException;

    public long countUnseenMessagesInMailbox(Mailbox<Id> var1) throws MailboxException;

    public void delete(Mailbox<Id> var1, Message<Id> var2) throws MailboxException;

    public Long findFirstUnseenMessageUid(Mailbox<Id> var1) throws MailboxException;

    public List<Long> findRecentMessageUidsInMailbox(Mailbox<Id> var1) throws MailboxException;

    public MessageMetaData add(Mailbox<Id> var1, Message<Id> var2) throws MailboxException;

    public Iterator<UpdatedFlags> updateFlags(Mailbox<Id> var1, Flags var2, boolean var3, boolean var4, MessageRange var5) throws MailboxException;

    public MessageMetaData copy(Mailbox<Id> var1, Message<Id> var2) throws MailboxException;

    public long getLastUid(Mailbox<Id> var1) throws MailboxException;

    public long getHighestModSeq(Mailbox<Id> var1) throws MailboxException;

    public static enum FetchType {
        Metadata,
        Headers,
        Body,
        Full;

    }

    public static interface MessageCallback<Id> {
        public void onMessages(List<Message<Id>> var1) throws MailboxException;
    }
}

