/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.mail.model;

import javax.mail.Flags;
import org.apache.james.mailbox.store.mail.model.Message;

public abstract class AbstractMessage<Id>
implements Message<Id> {
    @Override
    public int compareTo(Message<Id> other) {
        return (int)(this.getUid() - other.getUid());
    }

    @Override
    public final Flags createFlags() {
        String[] userFlags;
        Flags flags = new Flags();
        if (this.isAnswered()) {
            flags.add(Flags.Flag.ANSWERED);
        }
        if (this.isDeleted()) {
            flags.add(Flags.Flag.DELETED);
        }
        if (this.isDraft()) {
            flags.add(Flags.Flag.DRAFT);
        }
        if (this.isFlagged()) {
            flags.add(Flags.Flag.FLAGGED);
        }
        if (this.isRecent()) {
            flags.add(Flags.Flag.RECENT);
        }
        if (this.isSeen()) {
            flags.add(Flags.Flag.SEEN);
        }
        if ((userFlags = this.createUserFlags()) != null && userFlags.length > 0) {
            for (int i = 0; i < userFlags.length; ++i) {
                flags.add(userFlags[i]);
            }
        }
        return flags;
    }

    protected String[] createUserFlags() {
        return null;
    }

    @Override
    public long getBodyOctets() {
        return this.getFullContentOctets() - (long)this.getBodyStartOctet();
    }

    protected abstract int getBodyStartOctet();
}

