/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.mail.model.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.mail.Flags;
import javax.mail.internet.SharedInputStream;
import javax.mail.util.SharedByteArrayInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.store.ResultUtils;
import org.apache.james.mailbox.store.mail.model.AbstractMessage;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.Message;
import org.apache.james.mailbox.store.mail.model.Property;
import org.apache.james.mailbox.store.mail.model.impl.PropertyBuilder;
import org.apache.james.mailbox.store.mail.model.impl.SimpleProperty;

public class SimpleMessage<Id>
extends AbstractMessage<Id> {
    private long uid;
    private final Id mailboxId;
    private long size;
    private boolean answered;
    private boolean deleted;
    private boolean draft;
    private boolean flagged;
    private boolean recent;
    private boolean seen;
    private Date internalDate;
    private final String subType;
    private List<Property> properties;
    private final String mediaType;
    private Long lineCount;
    private int bodyStartOctet;
    private long modSeq;
    private SharedInputStream content;

    public SimpleMessage(Date internalDate, int size, int bodyStartOctet, SharedInputStream content, Flags flags, PropertyBuilder propertyBuilder, Id mailboxId) {
        this.content = content;
        this.size = size;
        this.bodyStartOctet = bodyStartOctet;
        this.setFlags(flags);
        this.lineCount = propertyBuilder.getTextualLineCount();
        this.internalDate = internalDate;
        this.mailboxId = mailboxId;
        this.properties = propertyBuilder.toProperties();
        this.mediaType = propertyBuilder.getMediaType();
        this.subType = propertyBuilder.getSubType();
    }

    public SimpleMessage(Mailbox<Id> mailbox, Message<Id> original) throws MailboxException {
        this.internalDate = original.getInternalDate();
        this.size = original.getFullContentOctets();
        this.mailboxId = mailbox.getMailboxId();
        this.setFlags(original.createFlags());
        try {
            this.content = new SharedByteArrayInputStream(IOUtils.toByteArray((InputStream)ResultUtils.toInput(original)));
        }
        catch (IOException e) {
            throw new MailboxException("Unable to parse message", (Exception)e);
        }
        this.bodyStartOctet = (int)(original.getFullContentOctets() - original.getBodyOctets());
        PropertyBuilder pBuilder = new PropertyBuilder(original.getProperties());
        this.lineCount = original.getTextualLineCount();
        this.mediaType = original.getMediaType();
        this.subType = original.getSubType();
        List<Property> properties = pBuilder.toProperties();
        this.properties = new ArrayList<Property>(properties.size());
        for (Property property : properties) {
            this.properties.add(new SimpleProperty(property));
        }
    }

    @Override
    public Date getInternalDate() {
        return this.internalDate;
    }

    @Override
    public Id getMailboxId() {
        return this.mailboxId;
    }

    @Override
    public long getUid() {
        return this.uid;
    }

    @Override
    public boolean isAnswered() {
        return this.answered;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public boolean isDraft() {
        return this.draft;
    }

    @Override
    public boolean isFlagged() {
        return this.flagged;
    }

    @Override
    public boolean isRecent() {
        return this.recent;
    }

    @Override
    public boolean isSeen() {
        return this.seen;
    }

    @Override
    public synchronized void setFlags(Flags flags) {
        this.answered = flags.contains(Flags.Flag.ANSWERED);
        this.deleted = flags.contains(Flags.Flag.DELETED);
        this.draft = flags.contains(Flags.Flag.DRAFT);
        this.flagged = flags.contains(Flags.Flag.FLAGGED);
        this.recent = flags.contains(Flags.Flag.RECENT);
        this.seen = flags.contains(Flags.Flag.SEEN);
    }

    @Override
    public InputStream getBodyContent() throws IOException {
        return this.content.newStream((long)this.getBodyStartOctet(), -1L);
    }

    @Override
    public long getFullContentOctets() {
        return this.size;
    }

    @Override
    public String getMediaType() {
        return this.mediaType;
    }

    @Override
    public List<Property> getProperties() {
        return this.properties;
    }

    @Override
    public String getSubType() {
        return this.subType;
    }

    @Override
    public Long getTextualLineCount() {
        return this.lineCount;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (int)(this.uid ^ this.uid >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleMessage other = (SimpleMessage)obj;
        return this.uid == other.uid;
    }

    public String toString() {
        return super.toString() + "[" + "uid = " + this.uid + " " + "mailboxId = " + this.mailboxId + " " + "size = " + this.size + " " + "answered = " + this.answered + " " + "deleted = " + this.deleted + " " + "draft = " + this.draft + " " + "flagged = " + this.flagged + " " + "recent = " + this.recent + " " + "seen = " + this.seen + " " + "internalDate = " + this.internalDate + " " + "subType = " + this.subType + " " + "mediaType = " + this.mediaType + " " + " ]";
    }

    @Override
    protected int getBodyStartOctet() {
        return this.bodyStartOctet;
    }

    @Override
    public long getModSeq() {
        return this.modSeq;
    }

    @Override
    public void setModSeq(long modSeq) {
        this.modSeq = modSeq;
    }

    @Override
    public void setUid(long uid) {
        this.uid = uid;
    }

    @Override
    public InputStream getHeaderContent() throws IOException {
        long headerEnd = this.getBodyStartOctet() - 2;
        if (headerEnd < 0L) {
            headerEnd = 0L;
        }
        return this.content.newStream(0L, headerEnd);
    }
}

