/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.quota;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MailboxListener;
import org.apache.james.mailbox.MailboxPath;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageRange;
import org.apache.james.mailbox.quota.Quota;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.StoreMailboxManager;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.model.Message;
import org.apache.james.mailbox.store.quota.QuotaImpl;

public abstract class ListeningQuotaManager
implements QuotaManager,
MailboxListener {
    private MailboxSessionMapperFactory factory;
    private ConcurrentHashMap<String, AtomicLong> counts = new ConcurrentHashMap();
    private ConcurrentHashMap<String, AtomicLong> sizes = new ConcurrentHashMap();
    private boolean calculateWhenUnlimited = false;

    public ListeningQuotaManager(StoreMailboxManager<?> manager) throws MailboxException {
        this.factory = manager.getMapperFactory();
        manager.addGlobalListener(this, null);
    }

    protected MailboxSessionMapperFactory<?> getFactory() {
        return this.factory;
    }

    public void setCalculateUsedWhenUnlimited(boolean calculateWhenUnlimited) {
        this.calculateWhenUnlimited = calculateWhenUnlimited;
    }

    public Quota getMessageQuota(MailboxSession session) throws MailboxException {
        long max = this.getMaxMessage(session);
        if (max != -1L || this.calculateWhenUnlimited) {
            String id = session.getUser().getUserName();
            AtomicLong count = this.counts.get(id);
            if (count == null) {
                long mc = 0L;
                List mailboxes = this.factory.getMailboxMapper(session).findMailboxWithPathLike(new MailboxPath(session.getPersonalSpace(), id, "%"));
                for (int i = 0; i < mailboxes.size(); ++i) {
                    mc += this.factory.getMessageMapper(session).countMessagesInMailbox(mailboxes.get(i));
                }
                AtomicLong c = this.counts.putIfAbsent(id, new AtomicLong(mc));
                if (c != null) {
                    count = c;
                }
            }
            return QuotaImpl.quota(max, count.get());
        }
        return QuotaImpl.unlimited();
    }

    public Quota getStorageQuota(MailboxSession session) throws MailboxException {
        long max = this.getMaxStorage(session);
        if (max != -1L || this.calculateWhenUnlimited) {
            String id = session.getUser().getUserName();
            AtomicLong size = this.sizes.get(id);
            if (size == null) {
                final AtomicLong mSizes = new AtomicLong(0L);
                List mailboxes = this.factory.getMailboxMapper(session).findMailboxWithPathLike(new MailboxPath(session.getPersonalSpace(), id, "%"));
                for (int i = 0; i < mailboxes.size(); ++i) {
                    this.factory.getMessageMapper(session).findInMailbox(mailboxes.get(i), MessageRange.all(), MessageMapper.FetchType.Metadata, new MessageMapper.MessageCallback<Object>(){
                        long messageSizes = 0L;

                        @Override
                        public void onMessages(List<Message<Object>> list) throws MailboxException {
                            for (int i = 0; i < list.size(); ++i) {
                                this.messageSizes += list.get(i).getFullContentOctets();
                            }
                            mSizes.set(mSizes.get() + this.messageSizes);
                        }
                    });
                }
                AtomicLong s = this.sizes.putIfAbsent(id, mSizes);
                size = s != null ? s : mSizes;
            }
            return QuotaImpl.quota(max, size.get());
        }
        return QuotaImpl.unlimited();
    }

    protected abstract long getMaxStorage(MailboxSession var1) throws MailboxException;

    protected abstract long getMaxMessage(MailboxSession var1) throws MailboxException;

    public void event(MailboxListener.Event event) {
        String id = event.getSession().getUser().getUserName();
        if (event instanceof MailboxListener.Added) {
            AtomicLong count;
            MailboxListener.Added added = (MailboxListener.Added)event;
            long s = 0L;
            long c = 0L;
            Iterator uids = added.getUids().iterator();
            while (uids.hasNext()) {
                long uid = (Long)uids.next();
                s += added.getMetaData(uid).getSize();
                ++c;
            }
            AtomicLong size = this.sizes.get(id);
            if (size != null) {
                long newValue;
                long expected;
                while (!size.compareAndSet(expected = size.get(), newValue = expected + s)) {
                }
            }
            if ((count = this.counts.get(id)) != null) {
                long newValue;
                long expected;
                while (!count.compareAndSet(expected = count.get(), newValue = expected + c)) {
                }
            }
        } else if (event instanceof MailboxListener.Expunged) {
            AtomicLong count;
            MailboxListener.Expunged expunged = (MailboxListener.Expunged)event;
            long s = 0L;
            long c = 0L;
            Iterator uids = expunged.getUids().iterator();
            while (uids.hasNext()) {
                long uid = (Long)uids.next();
                s += expunged.getMetaData(uid).getSize();
                ++c;
            }
            AtomicLong size = this.sizes.get(id);
            if (size != null) {
                long newValue;
                long expected;
                while (!size.compareAndSet(expected = size.get(), newValue = expected - s)) {
                }
            }
            if ((count = this.counts.get(id)) != null) {
                long newValue;
                long expected;
                while (!count.compareAndSet(expected = count.get(), newValue = expected - c)) {
                }
            }
        } else if (event instanceof MailboxListener.MailboxAdded) {
            this.counts.putIfAbsent(id, new AtomicLong(0L));
            this.sizes.putIfAbsent(id, new AtomicLong(0L));
        }
    }

    public boolean isClosed() {
        return false;
    }
}

