/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.quota;

import java.util.HashMap;
import java.util.Map;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.store.StoreMailboxManager;
import org.apache.james.mailbox.store.quota.ListeningQuotaManager;

public class PerUserQuotaManager<Id>
extends ListeningQuotaManager {
    private long maxMessage = -1L;
    private long maxStorage = -1L;
    private Map<String, Long> userMaxStorage = new HashMap<String, Long>();
    private Map<String, Long> userMaxMessage = new HashMap<String, Long>();

    public PerUserQuotaManager(StoreMailboxManager<Id> manager) throws MailboxException {
        super(manager);
    }

    public void setUserMaxStorage(Map<String, Long> userMaxStorage) {
        this.userMaxStorage = userMaxStorage;
    }

    public void setUserMaxMessage(Map<String, Long> userMaxMessage) {
        this.userMaxMessage = userMaxMessage;
    }

    public void setDefaultMaxStorage(long maxStorage) {
        this.maxStorage = maxStorage;
    }

    public void setDefaultMaxMessage(long maxMessage) {
        this.maxMessage = maxMessage;
    }

    @Override
    protected long getMaxStorage(MailboxSession session) throws MailboxException {
        Long max = this.userMaxStorage.get(session.getUser().getUserName());
        if (max == null) {
            max = this.maxStorage;
        }
        return max;
    }

    @Override
    protected long getMaxMessage(MailboxSession session) throws MailboxException {
        Long max = this.userMaxMessage.get(session.getUser().getUserName());
        if (max == null) {
            max = this.maxMessage;
        }
        return max;
    }
}

