/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.search;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.mail.Flags;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageRange;
import org.apache.james.mailbox.SearchQuery;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.Message;
import org.apache.james.mailbox.store.search.ListeningMessageSearchIndex;

public class LazyMessageSearchIndex<Id>
extends ListeningMessageSearchIndex<Id> {
    private ListeningMessageSearchIndex<Id> index;
    private final ConcurrentHashMap<Id, Boolean> indexed = new ConcurrentHashMap();

    public LazyMessageSearchIndex(ListeningMessageSearchIndex<Id> index) {
        super(index.getFactory());
        this.index = index;
    }

    @Override
    public void add(MailboxSession session, Mailbox<Id> mailbox, Message<Id> message) throws MailboxException {
        this.index.add(session, mailbox, message);
    }

    @Override
    public void delete(MailboxSession session, Mailbox<Id> mailbox, MessageRange range) throws MailboxException {
        this.index.delete(session, mailbox, range);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Long> search(final MailboxSession session, final Mailbox<Id> mailbox, SearchQuery searchQuery) throws MailboxException {
        Id id = mailbox.getMailboxId();
        Boolean done = this.indexed.get(id);
        if (done == null) {
            done = new Boolean(true);
            Boolean oldDone = this.indexed.putIfAbsent(id, done);
            if (oldDone != null) {
                done = oldDone;
            }
            Boolean bl = done;
            synchronized (bl) {
                this.getFactory().getMessageMapper(session).findInMailbox(mailbox, MessageRange.all(), MessageMapper.FetchType.Full, new MessageMapper.MessageCallback<Id>(){

                    @Override
                    public void onMessages(List<Message<Id>> list) throws MailboxException {
                        for (int i = 0; i < list.size(); ++i) {
                            Message message = list.get(i);
                            try {
                                LazyMessageSearchIndex.this.add(session, mailbox, message);
                                continue;
                            }
                            catch (MailboxException e) {
                                session.getLog().debug("Unable to index message " + message.getUid() + " in mailbox " + mailbox.getName(), (Throwable)e);
                            }
                        }
                    }
                });
            }
        }
        return this.index.search(session, mailbox, searchQuery);
    }

    @Override
    public void update(MailboxSession session, Mailbox<Id> mailbox, MessageRange range, Flags flags) throws MailboxException {
        this.index.update(session, mailbox, range, flags);
    }
}

