/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.search;

import java.util.List;
import javax.mail.Flags;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MailboxListener;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageRange;
import org.apache.james.mailbox.UpdatedFlags;
import org.apache.james.mailbox.store.MailboxEventDispatcher;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.MessageMapperFactory;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.Message;
import org.apache.james.mailbox.store.search.MessageSearchIndex;

public abstract class ListeningMessageSearchIndex<Id>
implements MessageSearchIndex<Id>,
MailboxListener {
    private MessageMapperFactory<Id> factory;

    public ListeningMessageSearchIndex(MessageMapperFactory<Id> factory) {
        this.factory = factory;
    }

    protected MessageMapperFactory<Id> getFactory() {
        return this.factory;
    }

    public void event(MailboxListener.Event event) {
        final MailboxSession session = event.getSession();
        try {
            if (event instanceof MailboxListener.MessageEvent) {
                if (event instanceof MailboxEventDispatcher.AddedImpl) {
                    MailboxEventDispatcher.AddedImpl added = (MailboxEventDispatcher.AddedImpl)event;
                    final Mailbox mailbox = added.getMailbox();
                    for (long next : added.getUids()) {
                        this.factory.getMessageMapper(session).findInMailbox(mailbox, MessageRange.one((long)next), MessageMapper.FetchType.Full, new MessageMapper.MessageCallback<Id>(){

                            @Override
                            public void onMessages(List<Message<Id>> list) throws MailboxException {
                                for (int i = 0; i < list.size(); ++i) {
                                    Message message = list.get(i);
                                    try {
                                        ListeningMessageSearchIndex.this.add(session, mailbox, message);
                                        continue;
                                    }
                                    catch (MailboxException e) {
                                        session.getLog().debug("Unable to index message " + message.getUid() + " for mailbox " + mailbox, (Throwable)e);
                                    }
                                }
                            }
                        });
                    }
                } else if (event instanceof MailboxEventDispatcher.ExpungedImpl) {
                    MailboxEventDispatcher.ExpungedImpl expunged = (MailboxEventDispatcher.ExpungedImpl)event;
                    Mailbox mailbox = expunged.getMailbox();
                    List<Long> uids = expunged.getUids();
                    List ranges = MessageRange.toRanges(uids);
                    for (int i = 0; i < ranges.size(); ++i) {
                        MessageRange range = (MessageRange)ranges.get(i);
                        try {
                            this.delete(session, mailbox, range);
                            continue;
                        }
                        catch (MailboxException e) {
                            session.getLog().debug("Unable to deleted range " + range.toString() + " from index for mailbox " + mailbox, (Throwable)e);
                        }
                    }
                } else if (event instanceof MailboxEventDispatcher.FlagsUpdatedImpl) {
                    MailboxEventDispatcher.FlagsUpdatedImpl flagsUpdated = (MailboxEventDispatcher.FlagsUpdatedImpl)event;
                    Mailbox mailbox = flagsUpdated.getMailbox();
                    for (UpdatedFlags uFlags : flagsUpdated.getUpdatedFlags()) {
                        try {
                            this.update(session, mailbox, MessageRange.one((long)uFlags.getUid()), uFlags.getNewFlags());
                        }
                        catch (MailboxException e) {
                            session.getLog().debug("Unable to update flags for message " + uFlags.getUid() + " in index for mailbox " + mailbox, (Throwable)e);
                        }
                    }
                }
            } else if (event instanceof MailboxEventDispatcher.MailboxDeletionImpl) {
                this.delete(session, ((MailboxEventDispatcher.MailboxDeletionImpl)event).getMailbox(), MessageRange.all());
            }
        }
        catch (MailboxException e) {
            session.getLog().debug("Unable to update index", (Throwable)e);
        }
    }

    public boolean isClosed() {
        return false;
    }

    public abstract void add(MailboxSession var1, Mailbox<Id> var2, Message<Id> var3) throws MailboxException;

    public abstract void delete(MailboxSession var1, Mailbox<Id> var2, MessageRange var3) throws MailboxException;

    public abstract void update(MailboxSession var1, Mailbox<Id> var2, MessageRange var3, Flags var4) throws MailboxException;
}

