/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.search;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.CharBuffer;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import org.apache.james.mailbox.store.streaming.ConfigurableMimeTokenStream;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.parser.MimeEntityConfig;
import org.apache.james.mime4j.parser.MimeTokenStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageSearcher {
    private Logger logger;
    private CharSequence searchContent = null;
    private boolean isCaseInsensitive = false;
    private boolean includeHeaders = false;

    public MessageSearcher() {
    }

    public MessageSearcher(CharSequence searchContent, boolean isCaseInsensitive, boolean includeHeaders) {
        this.searchContent = searchContent;
        this.isCaseInsensitive = isCaseInsensitive;
        this.includeHeaders = includeHeaders;
    }

    public boolean isIncludeHeaders() {
        return this.includeHeaders;
    }

    public synchronized void setIncludeHeaders(boolean includesHeaders) {
        this.includeHeaders = includesHeaders;
    }

    public boolean isCaseInsensitive() {
        return this.isCaseInsensitive;
    }

    public synchronized void setCaseInsensitive(boolean isCaseInsensitive) {
        this.isCaseInsensitive = isCaseInsensitive;
    }

    public CharSequence getSearchContent() {
        return this.searchContent;
    }

    public synchronized void setSearchContent(CharSequence searchContent) {
        this.searchContent = searchContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFoundIn(InputStream input) throws IOException, MimeException {
        boolean result;
        boolean isCaseInsensitive;
        CharSequence searchContent;
        boolean includeHeaders;
        MessageSearcher messageSearcher = this;
        synchronized (messageSearcher) {
            includeHeaders = this.includeHeaders;
            searchContent = this.searchContent;
            isCaseInsensitive = this.isCaseInsensitive;
        }
        if (searchContent == null || "".equals(searchContent)) {
            Logger logger = this.getLogger();
            logger.debug("Nothing to search for. ");
            result = false;
        } else {
            CharBuffer buffer = this.createBuffer(searchContent, isCaseInsensitive);
            result = this.parse(input, isCaseInsensitive, includeHeaders, buffer);
        }
        return result;
    }

    private boolean parse(InputStream input, boolean isCaseInsensitive, boolean includeHeaders, CharBuffer buffer) throws IOException, MimeException {
        try {
            boolean result = false;
            MimeEntityConfig config = new MimeEntityConfig();
            config.setMaxLineLen(-1);
            ConfigurableMimeTokenStream parser = new ConfigurableMimeTokenStream(config);
            parser.parse(input);
            while (!result && parser.next() != -1) {
                int state = parser.getState();
                switch (state) {
                    case 8: 
                    case 9: 
                    case 12: {
                        result = this.checkBody(isCaseInsensitive, buffer, result, parser);
                        break;
                    }
                    case 4: {
                        if (!includeHeaders) break;
                        result = this.checkHeader(isCaseInsensitive, buffer, result, parser);
                    }
                }
            }
            return result;
        }
        catch (IllegalCharsetNameException e) {
            this.handle(e);
        }
        catch (UnsupportedCharsetException e) {
            this.handle(e);
        }
        catch (IllegalStateException e) {
            this.handle(e);
        }
        return false;
    }

    private boolean checkHeader(boolean isCaseInsensitive, CharBuffer buffer, boolean result, MimeTokenStream parser) throws IOException {
        String value = parser.getField().getBody();
        StringReader reader = new StringReader(value);
        if (this.isFoundIn(reader, buffer, isCaseInsensitive)) {
            result = true;
        }
        return result;
    }

    private boolean checkBody(boolean isCaseInsensitive, CharBuffer buffer, boolean result, MimeTokenStream parser) throws IOException {
        Reader reader = parser.getReader();
        if (this.isFoundIn(reader, buffer, isCaseInsensitive)) {
            result = true;
        }
        return result;
    }

    private CharBuffer createBuffer(CharSequence searchContent, boolean isCaseInsensitive) {
        CharBuffer buffer;
        if (isCaseInsensitive) {
            int length = searchContent.length();
            buffer = CharBuffer.allocate(length);
            for (int i = 0; i < length; ++i) {
                char next = searchContent.charAt(i);
                char upperCase = Character.toUpperCase(next);
                buffer.put(upperCase);
            }
            buffer.flip();
        } else {
            buffer = CharBuffer.wrap(searchContent);
        }
        return buffer;
    }

    protected void handle(Exception e) throws IOException, MimeException {
        Logger logger = this.getLogger();
        logger.warn("Cannot read MIME body.");
        logger.debug("Failed to read body.", (Throwable)e);
    }

    private boolean isFoundIn(Reader reader, CharBuffer buffer, boolean isCaseInsensitive) throws IOException {
        int read;
        boolean result = false;
        while (!result && (read = reader.read()) != -1) {
            char next = isCaseInsensitive ? Character.toUpperCase((char)read) : (char)read;
            result = this.matches(buffer, next);
        }
        return result;
    }

    private boolean matches(CharBuffer buffer, char next) {
        boolean result = false;
        if (buffer.hasRemaining()) {
            boolean partialMatch = buffer.position() > 0;
            char matching = buffer.get();
            if (next != matching) {
                buffer.rewind();
                if (partialMatch) {
                    result = this.matches(buffer, next);
                }
            }
        } else {
            result = true;
        }
        return result;
    }

    public final Logger getLogger() {
        if (this.logger == null) {
            this.logger = LoggerFactory.getLogger(MessageSearcher.class);
        }
        return this.logger;
    }

    public final void setLogger(Logger logger) {
        this.logger = logger;
    }
}

