/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.search;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import javax.mail.Flags;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MessageResult;
import org.apache.james.mailbox.SearchQuery;
import org.apache.james.mailbox.UnsupportedSearchException;
import org.apache.james.mailbox.store.ResultUtils;
import org.apache.james.mailbox.store.mail.model.Message;
import org.apache.james.mailbox.store.search.MessageSearcher;
import org.apache.james.mailbox.store.search.comparator.CombinedComparator;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.field.address.Address;
import org.apache.james.mime4j.field.address.AddressList;
import org.apache.james.mime4j.field.address.Group;
import org.apache.james.mime4j.field.address.Mailbox;
import org.apache.james.mime4j.field.address.MailboxList;
import org.apache.james.mime4j.field.address.parser.ParseException;
import org.apache.james.mime4j.field.datetime.DateTime;
import org.apache.james.mime4j.field.datetime.parser.DateTimeParser;
import org.slf4j.Logger;

public class MessageSearches
implements Iterable<Long> {
    private Collection<Long> uids;

    public MessageSearches(Iterator<Message<?>> messages, SearchQuery query) {
        this(messages, query, null);
    }

    public MessageSearches(Iterator<Message<?>> messages, SearchQuery query, Logger log) {
        this.uids = MessageSearches.search(query, messages, log);
    }

    private static Collection<Long> search(SearchQuery query, Iterator<Message<?>> messages, Logger log) {
        TreeSet matched = new TreeSet(CombinedComparator.create(query.getSorts()));
        while (messages.hasNext()) {
            Message<?> m = messages.next();
            try {
                if (!MessageSearches.isMatch(query, m, log)) continue;
                matched.add(m);
            }
            catch (MailboxException e) {
                log.debug("Unable to search message " + m.getUid(), (Throwable)e);
            }
        }
        HashSet<Long> uids = new HashSet<Long>();
        Iterator<Message<?>> matchedIt = matched.iterator();
        while (matchedIt.hasNext()) {
            uids.add(matchedIt.next().getUid());
        }
        return uids;
    }

    public static boolean isMatch(SearchQuery query, Message<?> message, Logger log) throws MailboxException {
        List criteria = query.getCriterias();
        Set recentMessageUids = query.getRecentMessageUids();
        boolean result = true;
        if (criteria != null) {
            for (SearchQuery.Criterion criterion : criteria) {
                if (MessageSearches.isMatch(criterion, message, recentMessageUids, log)) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public static boolean isMatch(SearchQuery.Criterion criterion, Message<?> message, Collection<Long> recentMessageUids, Logger log) throws MailboxException {
        boolean result;
        if (criterion instanceof SearchQuery.InternalDateCriterion) {
            result = MessageSearches.matches((SearchQuery.InternalDateCriterion)criterion, message);
        } else if (criterion instanceof SearchQuery.SizeCriterion) {
            result = MessageSearches.matches((SearchQuery.SizeCriterion)criterion, message);
        } else if (criterion instanceof SearchQuery.HeaderCriterion) {
            try {
                result = MessageSearches.matches((SearchQuery.HeaderCriterion)criterion, message, log);
            }
            catch (IOException e) {
                throw new MailboxException("Unable to search header", (Exception)e);
            }
        } else if (criterion instanceof SearchQuery.UidCriterion) {
            result = MessageSearches.matches((SearchQuery.UidCriterion)criterion, message);
        } else if (criterion instanceof SearchQuery.FlagCriterion) {
            result = MessageSearches.matches((SearchQuery.FlagCriterion)criterion, message, recentMessageUids);
        } else if (criterion instanceof SearchQuery.CustomFlagCriterion) {
            result = MessageSearches.matches((SearchQuery.CustomFlagCriterion)criterion, message, recentMessageUids);
        } else if (criterion instanceof SearchQuery.TextCriterion) {
            result = MessageSearches.matches((SearchQuery.TextCriterion)criterion, message, log);
        } else if (criterion instanceof SearchQuery.AllCriterion) {
            result = true;
        } else if (criterion instanceof SearchQuery.ConjunctionCriterion) {
            result = MessageSearches.matches((SearchQuery.ConjunctionCriterion)criterion, message, recentMessageUids, log);
        } else if (criterion instanceof SearchQuery.ModSeqCriterion) {
            result = MessageSearches.matches((SearchQuery.ModSeqCriterion)criterion, message);
        } else {
            throw new UnsupportedSearchException();
        }
        return result;
    }

    private static boolean matches(SearchQuery.TextCriterion criterion, Message<?> message, Logger log) throws MailboxException {
        try {
            SearchQuery.ContainsOperator operator = criterion.getOperator();
            String value = operator.getValue();
            switch (criterion.getType()) {
                case BODY: {
                    return MessageSearches.bodyContains(value, message, log);
                }
                case FULL: {
                    return MessageSearches.messageContains(value, message, log);
                }
            }
            throw new UnsupportedSearchException();
        }
        catch (IOException e) {
            throw new MailboxException("Unable to parse message", (Exception)e);
        }
        catch (MimeException e) {
            throw new MailboxException("Unable to parse message", (Exception)((Object)e));
        }
    }

    private static boolean bodyContains(String value, Message<?> message, Logger log) throws IOException, MimeException {
        InputStream input = ResultUtils.toInput(message);
        boolean result = MessageSearches.isInMessage(value, input, false, log);
        return result;
    }

    private static boolean isInMessage(String value, InputStream input, boolean header, Logger log) throws IOException, MimeException {
        MessageSearcher searcher = new MessageSearcher(value, true, header);
        if (log != null) {
            searcher.setLogger(log);
        }
        boolean result = searcher.isFoundIn(input);
        return result;
    }

    private static boolean messageContains(String value, Message<?> message, Logger log) throws IOException, MimeException {
        InputStream input = ResultUtils.toInput(message);
        boolean result = MessageSearches.isInMessage(value, input, true, log);
        return result;
    }

    private static boolean matches(SearchQuery.ConjunctionCriterion criterion, Message<?> message, Collection<Long> recentMessageUids, Logger log) throws MailboxException {
        List criteria = criterion.getCriteria();
        switch (criterion.getType()) {
            case NOR: {
                return MessageSearches.nor(criteria, message, recentMessageUids, log);
            }
            case OR: {
                return MessageSearches.or(criteria, message, recentMessageUids, log);
            }
            case AND: {
                return MessageSearches.and(criteria, message, recentMessageUids, log);
            }
        }
        return false;
    }

    private static boolean and(List<SearchQuery.Criterion> criteria, Message<?> message, Collection<Long> recentMessageUids, Logger log) throws MailboxException {
        boolean result = true;
        for (SearchQuery.Criterion criterion : criteria) {
            boolean matches = MessageSearches.isMatch(criterion, message, recentMessageUids, log);
            if (matches) continue;
            result = false;
            break;
        }
        return result;
    }

    private static boolean or(List<SearchQuery.Criterion> criteria, Message<?> message, Collection<Long> recentMessageUids, Logger log) throws MailboxException {
        boolean result = false;
        for (SearchQuery.Criterion criterion : criteria) {
            boolean matches = MessageSearches.isMatch(criterion, message, recentMessageUids, log);
            if (!matches) continue;
            result = true;
            break;
        }
        return result;
    }

    private static boolean nor(List<SearchQuery.Criterion> criteria, Message<?> message, Collection<Long> recentMessageUids, Logger log) throws MailboxException {
        boolean result = true;
        for (SearchQuery.Criterion criterion : criteria) {
            boolean matches = MessageSearches.isMatch(criterion, message, recentMessageUids, log);
            if (!matches) continue;
            result = false;
            break;
        }
        return result;
    }

    private static boolean matches(SearchQuery.FlagCriterion criterion, Message<?> message, Collection<Long> recentMessageUids) {
        long uid;
        SearchQuery.BooleanOperator operator = criterion.getOperator();
        boolean isSet = operator.isSet();
        Flags.Flag flag = criterion.getFlag();
        boolean result = flag == Flags.Flag.ANSWERED ? isSet == message.isAnswered() : (flag == Flags.Flag.SEEN ? isSet == message.isSeen() : (flag == Flags.Flag.DRAFT ? isSet == message.isDraft() : (flag == Flags.Flag.FLAGGED ? isSet == message.isFlagged() : (flag == Flags.Flag.RECENT ? isSet == recentMessageUids.contains(uid = message.getUid()) : (flag == Flags.Flag.DELETED ? isSet == message.isDeleted() : false)))));
        return result;
    }

    private static boolean matches(SearchQuery.CustomFlagCriterion criterion, Message<?> message, Collection<Long> recentMessageUids) {
        SearchQuery.BooleanOperator operator = criterion.getOperator();
        boolean isSet = operator.isSet();
        String flag = criterion.getFlag();
        boolean result = isSet == message.createFlags().contains(flag);
        return result;
    }

    private static boolean matches(SearchQuery.UidCriterion criterion, Message<?> message) {
        SearchQuery.InOperator operator = criterion.getOperator();
        SearchQuery.NumericRange[] ranges = operator.getRange();
        long uid = message.getUid();
        int length = ranges.length;
        boolean result = false;
        for (int i = 0; i < length; ++i) {
            SearchQuery.NumericRange numericRange = ranges[i];
            if (!numericRange.isIn(uid)) continue;
            result = true;
            break;
        }
        return result;
    }

    private static boolean matches(SearchQuery.HeaderCriterion criterion, Message<?> message, Logger log) throws MailboxException, IOException {
        boolean result;
        SearchQuery.HeaderOperator operator = criterion.getOperator();
        String headerName = criterion.getHeaderName();
        if (operator instanceof SearchQuery.DateOperator) {
            result = MessageSearches.matches((SearchQuery.DateOperator)operator, headerName, message);
        } else if (operator instanceof SearchQuery.ContainsOperator) {
            result = MessageSearches.matches((SearchQuery.ContainsOperator)operator, headerName, message);
        } else if (operator instanceof SearchQuery.ExistsOperator) {
            result = MessageSearches.exists(headerName, message);
        } else if (operator instanceof SearchQuery.AddressOperator) {
            result = MessageSearches.matchesAddress((SearchQuery.AddressOperator)operator, headerName, message, log);
        } else {
            throw new UnsupportedSearchException();
        }
        return result;
    }

    private static boolean matchesAddress(SearchQuery.AddressOperator operator, String headerName, Message<?> message, Logger log) throws MailboxException, IOException {
        String text = operator.getAddress().toUpperCase(Locale.ENGLISH);
        List<MessageResult.Header> headers = ResultUtils.createHeaders(message);
        for (MessageResult.Header header : headers) {
            String name = header.getName();
            if (!headerName.equalsIgnoreCase(name)) continue;
            String value = header.getValue();
            try {
                AddressList aList = AddressList.parse((String)value);
                for (int i = 0; i < aList.size(); ++i) {
                    Address address = aList.get(i);
                    if (address instanceof Mailbox) {
                        if (!((Mailbox)address).getEncodedString().toUpperCase(Locale.ENGLISH).contains(text)) continue;
                        return true;
                    }
                    if (!(address instanceof Group)) continue;
                    MailboxList mList = ((Group)address).getMailboxes();
                    for (int a = 0; a < mList.size(); ++a) {
                        if (!mList.get(a).getEncodedString().toUpperCase(Locale.ENGLISH).contains(text)) continue;
                        return true;
                    }
                }
            }
            catch (ParseException e) {
                log.debug("Unable to parse address from header " + headerName, (Throwable)e);
            }
            return value.toUpperCase(Locale.ENGLISH).contains(text);
        }
        return false;
    }

    private static boolean exists(String headerName, Message<?> message) throws MailboxException, IOException {
        boolean result = false;
        List<MessageResult.Header> headers = ResultUtils.createHeaders(message);
        for (MessageResult.Header header : headers) {
            String name = header.getName();
            if (!headerName.equalsIgnoreCase(name)) continue;
            result = true;
            break;
        }
        return result;
    }

    private static boolean matches(SearchQuery.ContainsOperator operator, String headerName, Message<?> message) throws MailboxException, IOException {
        String text = operator.getValue().toUpperCase();
        boolean result = false;
        List<MessageResult.Header> headers = ResultUtils.createHeaders(message);
        for (MessageResult.Header header : headers) {
            String value;
            String name = header.getName();
            if (!headerName.equalsIgnoreCase(name) || (value = header.getValue()) == null || value.toUpperCase().indexOf(text) <= -1) continue;
            result = true;
            break;
        }
        return result;
    }

    private static boolean matches(SearchQuery.DateOperator operator, String headerName, Message<?> message) throws MailboxException {
        Date date = operator.getDate();
        SearchQuery.DateResolution res = operator.getDateResultion();
        try {
            String value = MessageSearches.headerValue(headerName, message);
            if (value == null) {
                return false;
            }
            try {
                Date isoFieldValue = MessageSearches.toISODate(value);
                SearchQuery.DateComparator type = operator.getType();
                switch (type) {
                    case AFTER: {
                        return MessageSearches.after(isoFieldValue, date, res);
                    }
                    case BEFORE: {
                        return MessageSearches.before(isoFieldValue, date, res);
                    }
                    case ON: {
                        return MessageSearches.on(isoFieldValue, date, res);
                    }
                }
                throw new UnsupportedSearchException();
            }
            catch (org.apache.james.mime4j.field.datetime.parser.ParseException e) {
                return false;
            }
        }
        catch (IOException e) {
            return false;
        }
    }

    private static String headerValue(String headerName, Message<?> message) throws MailboxException, IOException {
        List<MessageResult.Header> headers = ResultUtils.createHeaders(message);
        String value = null;
        for (MessageResult.Header header : headers) {
            String name = header.getName();
            if (!headerName.equalsIgnoreCase(name)) continue;
            value = header.getValue();
            break;
        }
        return value;
    }

    private static Date toISODate(String value) throws org.apache.james.mime4j.field.datetime.parser.ParseException {
        StringReader reader = new StringReader(value);
        DateTime dateTime = new DateTimeParser((Reader)reader).parseAll();
        Calendar cal = MessageSearches.getGMT();
        cal.set(dateTime.getYear(), dateTime.getMonth() - 1, dateTime.getDay(), dateTime.getHour(), dateTime.getMinute(), dateTime.getSecond());
        return cal.getTime();
    }

    private static boolean matches(SearchQuery.SizeCriterion criterion, Message<?> message) throws UnsupportedSearchException {
        SearchQuery.NumericOperator operator = criterion.getOperator();
        long size = message.getFullContentOctets();
        long value = operator.getValue();
        switch (operator.getType()) {
            case LESS_THAN: {
                return size < value;
            }
            case GREATER_THAN: {
                return size > value;
            }
            case EQUALS: {
                return size == value;
            }
        }
        throw new UnsupportedSearchException();
    }

    private static boolean matches(SearchQuery.ModSeqCriterion criterion, Message<?> message) throws UnsupportedSearchException {
        SearchQuery.NumericOperator operator = criterion.getOperator();
        long modSeq = message.getModSeq();
        long value = operator.getValue();
        switch (operator.getType()) {
            case LESS_THAN: {
                return modSeq < value;
            }
            case GREATER_THAN: {
                return modSeq > value;
            }
            case EQUALS: {
                return modSeq == value;
            }
        }
        throw new UnsupportedSearchException();
    }

    private static boolean matches(SearchQuery.InternalDateCriterion criterion, Message<?> message) throws UnsupportedSearchException {
        SearchQuery.DateOperator operator = criterion.getOperator();
        boolean result = MessageSearches.matchesInternalDate(operator, message);
        return result;
    }

    private static boolean matchesInternalDate(SearchQuery.DateOperator operator, Message<?> message) throws UnsupportedSearchException {
        Date date = operator.getDate();
        SearchQuery.DateResolution res = operator.getDateResultion();
        Date internalDate = message.getInternalDate();
        SearchQuery.DateComparator type = operator.getType();
        switch (type) {
            case ON: {
                return MessageSearches.on(internalDate, date, res);
            }
            case BEFORE: {
                return MessageSearches.before(internalDate, date, res);
            }
            case AFTER: {
                return MessageSearches.after(internalDate, date, res);
            }
        }
        throw new UnsupportedSearchException();
    }

    private static boolean on(Date date1, Date date2, SearchQuery.DateResolution res) {
        String d2;
        String d1 = MessageSearches.createDateString(date1, res);
        return d1.compareTo(d2 = MessageSearches.createDateString(date2, res)) == 0;
    }

    private static boolean before(Date date1, Date date2, SearchQuery.DateResolution res) {
        String d2;
        String d1 = MessageSearches.createDateString(date1, res);
        return d1.compareTo(d2 = MessageSearches.createDateString(date2, res)) < 0;
    }

    private static boolean after(Date date1, Date date2, SearchQuery.DateResolution res) {
        String d2;
        String d1 = MessageSearches.createDateString(date1, res);
        return d1.compareTo(d2 = MessageSearches.createDateString(date2, res)) > 0;
    }

    private static String createDateString(Date date, SearchQuery.DateResolution res) {
        SimpleDateFormat format;
        switch (res) {
            case Year: {
                format = new SimpleDateFormat("yyyy");
                break;
            }
            case Month: {
                format = new SimpleDateFormat("yyyyMM");
                break;
            }
            case Day: {
                format = new SimpleDateFormat("yyyyMMdd");
                break;
            }
            case Hour: {
                format = new SimpleDateFormat("yyyyMMddhh");
                break;
            }
            case Minute: {
                format = new SimpleDateFormat("yyyyMMddhhmm");
                break;
            }
            case Second: {
                format = new SimpleDateFormat("yyyyMMddhhmmss");
                break;
            }
            default: {
                format = new SimpleDateFormat("yyyyMMddhhmmssSSS");
            }
        }
        format.setCalendar(MessageSearches.getGMT());
        return format.format(date);
    }

    private static Calendar getGMT() {
        return Calendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.ENGLISH);
    }

    @Override
    public Iterator<Long> iterator() {
        return this.uids.iterator();
    }
}

